/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.Optional;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.PhysicalStateHandleID;
import org.apache.flink.runtime.state.StreamStateHandle;

public class PlaceholderStreamStateHandle
implements StreamStateHandle {
    private static final long serialVersionUID = 1L;
    private final PhysicalStateHandleID physicalID;
    private final long stateSize;
    private final boolean fileMerged;

    public PlaceholderStreamStateHandle(PhysicalStateHandleID physicalID, long stateSize, boolean fileMerged) {
        this.physicalID = physicalID;
        this.stateSize = stateSize;
        this.fileMerged = fileMerged;
    }

    @Override
    public FSDataInputStream openInputStream() {
        throw new UnsupportedOperationException("This is only a placeholder to be replaced by a real StreamStateHandle in the checkpoint coordinator.");
    }

    @Override
    public Optional<byte[]> asBytesIfInMemory() {
        throw new UnsupportedOperationException("This is only a placeholder to be replaced by a real StreamStateHandle in the checkpoint coordinator.");
    }

    @Override
    public PhysicalStateHandleID getStreamStateHandleID() {
        return this.physicalID;
    }

    @Override
    public void discardState() throws Exception {
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    public boolean isFileMerged() {
        return this.fileMerged;
    }
}

