/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence.converter;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={List.class})
public class List2StringConverter
implements TypeHandler<List> {
    private final String separator = ",";

    public void setParameter(PreparedStatement ps, int i, List parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null) {
            ps.setString(i, null);
            return;
        }
        StringBuilder builder = new StringBuilder();
        Iterator iterator = parameter.iterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        ps.setString(i, builder.toString());
    }

    public List getResult(ResultSet rs, String columnName) throws SQLException {
        String res = rs.getString(columnName);
        if (res == null) {
            return null;
        }
        ArrayList set = new ArrayList();
        if (res.length() != 0) {
            String[] fields = res.split(",");
            Collections.addAll(set, fields);
        }
        return set;
    }

    public List getResult(ResultSet rs, int columnIndex) throws SQLException {
        String res = rs.getString(columnIndex);
        if (res == null) {
            return null;
        }
        ArrayList set = new ArrayList();
        if (res.length() != 0) {
            String[] fields = res.split(",");
            Collections.addAll(set, fields);
        }
        return set;
    }

    public List getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String res = cs.getString(columnIndex);
        if (res == null) {
            return null;
        }
        ArrayList set = new ArrayList();
        if (res.length() != 0) {
            String[] fields = res.split(",");
            Collections.addAll(set, fields);
        }
        return set;
    }
}

