/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table;

import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.metrics.Counter;
import org.apache.amoro.metrics.Gauge;
import org.apache.amoro.metrics.Metric;
import org.apache.amoro.metrics.MetricDefine;
import org.apache.amoro.optimizing.OptimizingType;
import org.apache.amoro.server.metrics.MetricRegistry;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.optimizing.maintainer.IcebergTableMaintainer;
import org.apache.amoro.server.table.AbstractTableMetrics;
import org.apache.amoro.shade.guava32.com.google.common.primitives.Longs;
import org.apache.iceberg.Snapshot;

public class TableOptimizingMetrics
extends AbstractTableMetrics {
    public static final String STATUS_IDLE = "idle";
    public static final String STATUS_PENDING = "pending";
    public static final String STATUS_PLANING = "planing";
    public static final String STATUS_EXECUTING = "executing";
    public static final String STATUS_COMMITTING = "committing";
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IDLE_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_idle_duration_mills").withDescription("Duration in milliseconds after table be in idle status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_PENDING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_pending_duration_mills").withDescription("Duration in milliseconds after table be in pending status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_PLANNING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_planning_duration_mills").withDescription("Duration in milliseconds after table be in planning status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_EXECUTING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_executing_duration_mills").withDescription("Duration in milliseconds after table be in executing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_COMMITTING_DURATION = MetricDefine.defineGauge((String)"table_optimizing_status_committing_duration_mills").withDescription("Duration in milliseconds after table be in committing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_PROCESS_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_process_total_count").withDescription("Count of all optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_PROCESS_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_process_failed_count").withDescription("Count of failed optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MINOR_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_minor_total_count").withDescription("Count of minor optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MINOR_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_minor_failed_count").withDescription("Count of failed minor optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MAJOR_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_major_total_count").withDescription("Count of major optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_MAJOR_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_major_failed_count").withDescription("Count of failed major optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_FULL_TOTAL_COUNT = MetricDefine.defineCounter((String)"table_optimizing_full_total_count").withDescription("Count of full optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_FULL_FAILED_COUNT = MetricDefine.defineCounter((String)"table_optimizing_full_failed_count").withDescription("Count of failed full optimizing process since ams started").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_IDLE = MetricDefine.defineGauge((String)"table_optimizing_status_in_idle").withDescription("If currently table is in idle status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_PENDING = MetricDefine.defineGauge((String)"table_optimizing_status_in_pending").withDescription("If currently table is in pending status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_PLANNING = MetricDefine.defineGauge((String)"table_optimizing_status_in_planning").withDescription("If currently table is in planning status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_EXECUTING = MetricDefine.defineGauge((String)"table_optimizing_status_in_executing").withDescription("If currently table is in executing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_STATUS_IN_COMMITTING = MetricDefine.defineGauge((String)"table_optimizing_status_in_committing").withDescription("If currently table is in committing status").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_SINCE_LAST_MINOR_OPTIMIZATION = MetricDefine.defineGauge((String)"table_optimizing_since_last_minor_optimization_mills").withDescription("Duration in milliseconds since last successful minor optimization").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_SINCE_LAST_MAJOR_OPTIMIZATION = MetricDefine.defineGauge((String)"table_optimizing_since_last_major_optimization_mills").withDescription("Duration in milliseconds since last successful major optimization").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_SINCE_LAST_FULL_OPTIMIZATION = MetricDefine.defineGauge((String)"table_optimizing_since_last_full_optimization_mills").withDescription("Duration in milliseconds since last successful full optimization").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_SINCE_LAST_OPTIMIZATION = MetricDefine.defineGauge((String)"table_optimizing_since_last_optimization_mills").withDescription("Duration in milliseconds since last successful optimization").withTags(new String[]{"catalog", "database", "table"}).build();
    public static final MetricDefine TABLE_OPTIMIZING_LAG_DURATION = MetricDefine.defineGauge((String)"table_optimizing_lag_duration_mills").withDescription("Duration in milliseconds between last self-optimizing snapshot and refreshed snapshot").withTags(new String[]{"catalog", "database", "table"}).build();
    private final Counter processTotalCount = new Counter();
    private final Counter processFailedCount = new Counter();
    private final Counter minorTotalCount = new Counter();
    private final Counter minorFailedCount = new Counter();
    private final Counter majorTotalCount = new Counter();
    private final Counter majorFailedCount = new Counter();
    private final Counter fullTotalCount = new Counter();
    private final Counter fullFailedCount = new Counter();
    private OptimizingStatus optimizingStatus = OptimizingStatus.IDLE;
    private long statusSetTimestamp = System.currentTimeMillis();
    private long lastMinorTime;
    private long lastMajorTime;
    private long lastFullTime;
    private long lastNonMaintainedTime = 0L;
    private long lastOptimizingTime = 0L;

    public TableOptimizingMetrics(ServerTableIdentifier identifier) {
        super(identifier);
    }

    @Override
    public void registerMetrics(MetricRegistry registry) {
        if (this.globalRegistry == null) {
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IDLE_DURATION, (Metric)new StatusDurationGauge(STATUS_IDLE));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_PENDING_DURATION, (Metric)new StatusDurationGauge(STATUS_PENDING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_PLANNING_DURATION, (Metric)new StatusDurationGauge(STATUS_PLANING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_EXECUTING_DURATION, (Metric)new StatusDurationGauge(STATUS_EXECUTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_COMMITTING_DURATION, (Metric)new StatusDurationGauge(STATUS_COMMITTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_IDLE, (Metric)new IsInStatusGauge(STATUS_IDLE));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_PENDING, (Metric)new IsInStatusGauge(STATUS_PENDING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_PLANNING, (Metric)new IsInStatusGauge(STATUS_PLANING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_EXECUTING, (Metric)new IsInStatusGauge(STATUS_EXECUTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_STATUS_IN_COMMITTING, (Metric)new IsInStatusGauge(STATUS_COMMITTING));
            this.registerMetric(registry, TABLE_OPTIMIZING_PROCESS_TOTAL_COUNT, (Metric)this.processTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_PROCESS_FAILED_COUNT, (Metric)this.processFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MINOR_TOTAL_COUNT, (Metric)this.minorTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MINOR_FAILED_COUNT, (Metric)this.minorFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MAJOR_TOTAL_COUNT, (Metric)this.majorTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_MAJOR_FAILED_COUNT, (Metric)this.majorFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_FULL_TOTAL_COUNT, (Metric)this.fullTotalCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_FULL_FAILED_COUNT, (Metric)this.fullFailedCount);
            this.registerMetric(registry, TABLE_OPTIMIZING_SINCE_LAST_MINOR_OPTIMIZATION, (Metric)new LastOptimizingDurationGauge(OptimizingType.MINOR));
            this.registerMetric(registry, TABLE_OPTIMIZING_SINCE_LAST_MAJOR_OPTIMIZATION, (Metric)new LastOptimizingDurationGauge(OptimizingType.MAJOR));
            this.registerMetric(registry, TABLE_OPTIMIZING_SINCE_LAST_FULL_OPTIMIZATION, (Metric)new LastOptimizingDurationGauge(OptimizingType.FULL));
            this.registerMetric(registry, TABLE_OPTIMIZING_SINCE_LAST_OPTIMIZATION, (Metric)new LastOptimizingDurationGauge());
            this.registerMetric(registry, TABLE_OPTIMIZING_LAG_DURATION, (Metric)new OptimizingLagDurationGauge());
            this.globalRegistry = registry;
        }
    }

    public void statusChanged(OptimizingStatus optimizingStatus, long statusSetTimestamp) {
        this.optimizingStatus = optimizingStatus;
        this.statusSetTimestamp = statusSetTimestamp;
    }

    public void lastOptimizingTime(OptimizingType processType, long lastTime) {
        switch (processType) {
            case MINOR: {
                this.lastMinorTime = lastTime;
                break;
            }
            case MAJOR: {
                this.lastMajorTime = lastTime;
                break;
            }
            case FULL: {
                this.lastFullTime = lastTime;
            }
        }
    }

    public void nonMaintainedSnapshotTime(Snapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        if (snapshot.summary().values().stream().anyMatch(IcebergTableMaintainer.AMORO_MAINTAIN_COMMITS::contains) || Long.parseLong(snapshot.summary().getOrDefault("added-data-files", "0")) == 0L) {
            return;
        }
        this.lastNonMaintainedTime = Longs.max((long[])new long[]{this.lastNonMaintainedTime, snapshot.timestampMillis()});
    }

    public void lastOptimizingSnapshotTime(Snapshot snapshot) {
        if (snapshot == null) {
            return;
        }
        this.lastOptimizingTime = Longs.max((long[])new long[]{this.lastOptimizingTime, snapshot.timestampMillis(), Longs.max((long[])new long[]{this.lastMinorTime, this.lastMajorTime, this.lastFullTime})});
    }

    public void processComplete(OptimizingType processType, boolean success, long planTime) {
        this.processTotalCount.inc();
        Counter totalCounter = null;
        Counter failedCounter = null;
        switch (processType) {
            case MINOR: {
                totalCounter = this.minorTotalCount;
                failedCounter = this.minorFailedCount;
                break;
            }
            case MAJOR: {
                totalCounter = this.majorTotalCount;
                failedCounter = this.majorFailedCount;
                break;
            }
            case FULL: {
                totalCounter = this.fullTotalCount;
                failedCounter = this.fullFailedCount;
            }
        }
        if (success) {
            this.lastOptimizingTime(processType, planTime);
        }
        if (totalCounter != null) {
            totalCounter.inc();
        }
        if (!success && failedCounter != null) {
            failedCounter.inc();
        }
    }

    private String getOptimizingStatusDesc(OptimizingStatus status) {
        switch (status) {
            case IDLE: {
                return STATUS_IDLE;
            }
            case PENDING: {
                return STATUS_PENDING;
            }
            case PLANNING: {
                return STATUS_PLANING;
            }
            case FULL_OPTIMIZING: 
            case MAJOR_OPTIMIZING: 
            case MINOR_OPTIMIZING: {
                return STATUS_EXECUTING;
            }
            case COMMITTING: {
                return STATUS_COMMITTING;
            }
        }
        return status.name();
    }

    class IsInStatusGauge
    implements Gauge<Long> {
        final String targetStatus;

        IsInStatusGauge(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        public Long getValue() {
            String status = TableOptimizingMetrics.this.getOptimizingStatusDesc(TableOptimizingMetrics.this.optimizingStatus);
            if (this.targetStatus.equals(status)) {
                return 1L;
            }
            return 0L;
        }
    }

    class OptimizingLagDurationGauge
    implements Gauge<Long> {
        OptimizingLagDurationGauge() {
        }

        public Long getValue() {
            if (TableOptimizingMetrics.this.lastNonMaintainedTime == 0L || TableOptimizingMetrics.this.lastOptimizingTime == 0L) {
                return 0L;
            }
            return TableOptimizingMetrics.this.lastNonMaintainedTime - TableOptimizingMetrics.this.lastOptimizingTime;
        }
    }

    class LastOptimizingDurationGauge
    implements Gauge<Long> {
        final OptimizingType optimizingType;

        LastOptimizingDurationGauge(OptimizingType optimizingType) {
            this.optimizingType = optimizingType;
        }

        LastOptimizingDurationGauge() {
            this.optimizingType = null;
        }

        public Long getValue() {
            if (this.optimizingType == null) {
                return this.optimizingInterval(TableOptimizingMetrics.this.lastOptimizingTime);
            }
            switch (this.optimizingType) {
                case MINOR: {
                    return this.optimizingInterval(TableOptimizingMetrics.this.lastMinorTime);
                }
                case MAJOR: {
                    return this.optimizingInterval(TableOptimizingMetrics.this.lastMajorTime);
                }
                case FULL: {
                    return this.optimizingInterval(TableOptimizingMetrics.this.lastFullTime);
                }
            }
            return 0L;
        }

        private long optimizingInterval(long lastOptimizedTime) {
            return lastOptimizedTime > 0L ? System.currentTimeMillis() - lastOptimizedTime : 0L;
        }
    }

    class StatusDurationGauge
    implements Gauge<Long> {
        final String targetStatus;

        StatusDurationGauge(String targetStatus) {
            this.targetStatus = targetStatus;
        }

        public Long getValue() {
            String status = TableOptimizingMetrics.this.getOptimizingStatusDesc(TableOptimizingMetrics.this.optimizingStatus);
            if (this.targetStatus.equals(status)) {
                return this.statusDuration();
            }
            return 0L;
        }

        private Long statusDuration() {
            return System.currentTimeMillis() - TableOptimizingMetrics.this.statusSetTimestamp;
        }
    }
}

