/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.io.writer;

import org.apache.amoro.data.FileNameRules;
import org.apache.amoro.hive.utils.HiveTableUtil;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.TaskWriterKey;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.OutputFile;

public class AdaptHiveOutputFileFactory
implements OutputFileFactory {
    private final String hiveLocation;
    private final String hiveSubDirectory;
    private final PartitionSpec partitionSpec;
    private final AuthenticatedFileIO io;
    private final EncryptionManager encryptionManager;
    private final FileNameRules fileNameGenerator;
    private final boolean hiveConsistentWrite;

    public AdaptHiveOutputFileFactory(String hiveLocation, PartitionSpec partitionSpec, FileFormat format, AuthenticatedFileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, Long transactionId, boolean hiveConsistentWrite) {
        this(hiveLocation, partitionSpec, format, io, encryptionManager, partitionId, taskId, transactionId, null, hiveConsistentWrite);
    }

    public AdaptHiveOutputFileFactory(String hiveLocation, PartitionSpec partitionSpec, FileFormat format, AuthenticatedFileIO io, EncryptionManager encryptionManager, int partitionId, long taskId, Long transactionId, String hiveSubDirectory, boolean hiveConsistentWrite) {
        this.hiveLocation = hiveLocation;
        this.partitionSpec = partitionSpec;
        this.io = io;
        this.encryptionManager = encryptionManager;
        this.hiveSubDirectory = hiveSubDirectory == null ? (transactionId != null ? HiveTableUtil.newHiveSubdirectory(transactionId) : HiveTableUtil.newHiveSubdirectory()) : hiveSubDirectory;
        this.fileNameGenerator = new FileNameRules(format, partitionId, Long.valueOf(taskId), transactionId);
        this.hiveConsistentWrite = hiveConsistentWrite;
    }

    private String generateFilename(TaskWriterKey key) {
        String filename = this.fileNameGenerator.fileName(key);
        if (this.hiveConsistentWrite) {
            filename = "." + filename;
        }
        return filename;
    }

    private String fileLocation(StructLike partitionData, String fileName) {
        return String.format("%s/%s", HiveTableUtil.newHiveDataLocation(this.hiveLocation, this.partitionSpec, partitionData, this.hiveSubDirectory), fileName);
    }

    public EncryptedOutputFile newOutputFile(TaskWriterKey key) {
        String fileLocation = this.fileLocation(key.getPartitionKey(), this.generateFilename(key));
        OutputFile outputFile = this.io.newOutputFile(fileLocation);
        return this.encryptionManager.encrypt(outputFile);
    }
}

