/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.table;

import java.util.Map;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.TableMeta;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.BaseSchemaUpdate;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.hive.utils.HiveMetaSynchronizer;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.scan.ChangeTableIncrementalScan;
import org.apache.amoro.table.BaseTable;
import org.apache.amoro.table.BasicKeyedTable;
import org.apache.amoro.table.BasicUnkeyedTable;
import org.apache.amoro.table.ChangeTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.MixedChangeTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.util.PropertyUtil;

public class KeyedHiveTable
extends BasicKeyedTable
implements SupportHive {
    private final HMSClientPool hiveClient;

    public KeyedHiveTable(TableMeta tableMeta, String tableLocation, PrimaryKeySpec primaryKeySpec, HMSClientPool hiveClient, UnkeyedHiveTable baseTable, ChangeTable changeTable) {
        super(tableLocation, primaryKeySpec, (BaseTable)baseTable, changeTable);
        this.hiveClient = hiveClient;
        if (this.enableSyncHiveSchemaToMixedTable()) {
            this.syncHiveSchemaToMixedTable();
        }
        if (this.enableSyncHiveDataToMixedTable()) {
            this.syncHiveDataToMixedTable(false);
        }
    }

    @Override
    public AuthenticatedHadoopFileIO io() {
        return (AuthenticatedHadoopFileIO)super.io();
    }

    public TableFormat format() {
        return TableFormat.MIXED_HIVE;
    }

    public void refresh() {
        super.refresh();
        if (this.enableSyncHiveSchemaToMixedTable()) {
            this.syncHiveSchemaToMixedTable();
        }
        if (this.enableSyncHiveDataToMixedTable()) {
            this.syncHiveDataToMixedTable(false);
        }
    }

    @Override
    public String hiveLocation() {
        return ((SupportHive)this.baseTable()).hiveLocation();
    }

    @Override
    public boolean enableSyncHiveSchemaToMixedTable() {
        return PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-schema-change", (boolean)true);
    }

    @Override
    public void syncHiveSchemaToMixedTable() {
        HiveMetaSynchronizer.syncHiveSchemaToMixedTable(this, this.hiveClient);
    }

    @Override
    public boolean enableSyncHiveDataToMixedTable() {
        return PropertyUtil.propertyAsBoolean((Map)this.properties(), (String)"base.hive.auto-sync-data-write", (boolean)false);
    }

    @Override
    public void syncHiveDataToMixedTable(boolean force) {
        HiveMetaSynchronizer.syncHiveDataToMixedTable(this, this.hiveClient, force);
    }

    @Override
    public HMSClientPool getHMSClient() {
        return this.hiveClient;
    }

    public static class HiveBaseInternalTable
    extends UnkeyedHiveTable
    implements BaseTable {
        public HiveBaseInternalTable(TableIdentifier tableIdentifier, Table icebergTable, AuthenticatedHadoopFileIO fileIO, String tableLocation, HMSClientPool hiveClient, Map<String, String> catalogProperties, boolean syncHiveChange) {
            super(tableIdentifier, icebergTable, fileIO, tableLocation, hiveClient, catalogProperties, syncHiveChange);
        }

        @Override
        public TableFormat format() {
            return TableFormat.MIXED_HIVE;
        }
    }

    public static class HiveChangeInternalTable
    extends BasicUnkeyedTable
    implements ChangeTable {
        public HiveChangeInternalTable(TableIdentifier tableIdentifier, Table changeIcebergTable, AuthenticatedFileIO authenticatedFileIO, Map<String, String> catalogProperties) {
            super(tableIdentifier, changeIcebergTable, authenticatedFileIO, catalogProperties);
        }

        public TableFormat format() {
            return TableFormat.MIXED_HIVE;
        }

        public UpdateSchema updateSchema() {
            return new BaseSchemaUpdate((MixedTable)this, super.updateSchema());
        }

        public ChangeTableIncrementalScan newScan() {
            return new MixedChangeTableScan((Table)this, this.schema());
        }
    }
}

