/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.amoro.io.AuthenticatedHadoopFileIO;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;

public class HiveCommitUtil {
    public static List<DataFile> commitConsistentWriteFiles(List<DataFile> dataFiles, AuthenticatedHadoopFileIO fileIO, PartitionSpec spec) {
        return HiveCommitUtil.applyConsistentWriteFile(dataFiles, spec, (location, committed) -> {
            if (!fileIO.exists(committed)) {
                fileIO.rename(location, committed);
            }
        });
    }

    public static List<DataFile> applyConsistentWriteFile(List<DataFile> dataFiles, PartitionSpec spec, HiveFileCommitter hiveFileCommitter) {
        ArrayList afterCommittedFiles = Lists.newArrayList();
        for (DataFile file : dataFiles) {
            String filename = TableFileUtil.getFileName((String)file.path().toString());
            if (!filename.startsWith(".")) {
                afterCommittedFiles.add(file);
                continue;
            }
            String committedFilename = filename.substring(1);
            String committedLocation = TableFileUtil.getFileDir((String)file.path().toString()) + "/" + committedFilename;
            hiveFileCommitter.commit(file.path().toString(), committedLocation);
            DataFile committedDatafile = DataFiles.builder((PartitionSpec)spec).copy(file).withPath(committedLocation).build();
            afterCommittedFiles.add(committedDatafile);
        }
        return afterCommittedFiles;
    }

    @FunctionalInterface
    public static interface HiveFileCommitter {
        public void commit(String var1, String var2);
    }
}

