/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ConnectorOptionsCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorDataTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorDataTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConnectorDataTarget.getter(ConnectorDataTarget::name)).setter(ConnectorDataTarget.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionType").getter(ConnectorDataTarget.getter(ConnectorDataTarget::connectionType)).setter(ConnectorDataTarget.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionType").build()}).build();
    private static final SdkField<Map<String, String>> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Data").getter(ConnectorDataTarget.getter(ConnectorDataTarget::data)).setter(ConnectorDataTarget.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(ConnectorDataTarget.getter(ConnectorDataTarget::inputs)).setter(ConnectorDataTarget.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CONNECTION_TYPE_FIELD, DATA_FIELD, INPUTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String connectionType;
    private final Map<String, String> data;
    private final List<String> inputs;

    private ConnectorDataTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.connectionType = builder.connectionType;
        this.data = builder.data;
        this.inputs = builder.inputs;
    }

    public final String name() {
        return this.name;
    }

    public final String connectionType() {
        return this.connectionType;
    }

    public final boolean hasData() {
        return this.data != null && !(this.data instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> data() {
        return this.data;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasData() ? this.data() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorDataTarget)) {
            return false;
        }
        ConnectorDataTarget other = (ConnectorDataTarget)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.connectionType(), other.connectionType()) && this.hasData() == other.hasData() && Objects.equals(this.data(), other.data()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorDataTarget").add("Name", (Object)this.name()).add("ConnectionType", (Object)this.connectionType()).add("Data", this.hasData() ? this.data() : null).add("Inputs", this.hasInputs() ? this.inputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ConnectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionType()));
            }
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConnectorDataTarget, T> g) {
        return obj -> g.apply((ConnectorDataTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String connectionType;
        private Map<String, String> data = DefaultSdkAutoConstructMap.getInstance();
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorDataTarget model) {
            this.name(model.name);
            this.connectionType(model.connectionType);
            this.data(model.data);
            this.inputs(model.inputs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public final Map<String, String> getData() {
            if (this.data instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.data;
        }

        public final void setData(Map<String, String> data) {
            this.data = ConnectorOptionsCopier.copy(data);
        }

        @Override
        public final Builder data(Map<String, String> data) {
            this.data = ConnectorOptionsCopier.copy(data);
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public ConnectorDataTarget build() {
            return new ConnectorDataTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorDataTarget> {
        public Builder name(String var1);

        public Builder connectionType(String var1);

        public Builder data(Map<String, String> var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);
    }
}

