/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GlueRecordType {
    DATE("DATE"),
    STRING("STRING"),
    TIMESTAMP("TIMESTAMP"),
    INT("INT"),
    FLOAT("FLOAT"),
    LONG("LONG"),
    BIGDECIMAL("BIGDECIMAL"),
    BYTE("BYTE"),
    SHORT("SHORT"),
    DOUBLE("DOUBLE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GlueRecordType> VALUE_MAP;
    private final String value;

    private GlueRecordType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GlueRecordType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GlueRecordType> knownValues() {
        EnumSet<GlueRecordType> knownValues = EnumSet.allOf(GlueRecordType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GlueRecordType.class, GlueRecordType::toString);
    }
}

