/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallyPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final TerminalSignalConsumer doFinally;

    AfterFinallyPublisher(Publisher<T> original, TerminalSignalConsumer doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new AfterFinallyPublisherSubscriber<T>(subscriber, this.doFinally);
    }

    private static final class AfterFinallyPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final TerminalSignalConsumer doFinally;
        private static final AtomicIntegerFieldUpdater<AfterFinallyPublisherSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallyPublisherSubscriber.class, "done");
        private volatile int done;

        AfterFinallyPublisherSubscriber(PublisherSource.Subscriber<? super T> original, TerminalSignalConsumer doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        public void onSubscribe(final PublisherSource.Subscription s) {
            this.original.onSubscribe(new PublisherSource.Subscription(){

                public void request(long n) {
                    s.request(n);
                }

                public void cancel() {
                    try {
                        s.cancel();
                    }
                    finally {
                        if (doneUpdater.compareAndSet(this, 0, 1)) {
                            doFinally.cancel();
                        }
                    }
                }
            });
        }

        public void onNext(T t) {
            this.original.onNext(t);
        }

        public void onComplete() {
            try {
                this.original.onComplete();
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onComplete();
                }
            }
        }

        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
        }
    }
}

