/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class CompositeExceptionUtils {
    private static final int DEFAULT_MAX_EXCEPTIONS = 1;

    private CompositeExceptionUtils() {
    }

    static <T> void addPendingError(AtomicIntegerFieldUpdater<T> updater, T owner, int maxDelayedErrors, Throwable original, Throwable causeToAdd) {
        int newSize = updater.incrementAndGet(owner);
        if (newSize < 0) {
            updater.set(owner, Integer.MAX_VALUE);
        } else if (newSize < maxDelayedErrors && original != causeToAdd) {
            original.addSuppressed(causeToAdd);
        } else {
            updater.decrementAndGet(owner);
        }
    }

    static int maxDelayedErrors(boolean delayError) {
        return delayError ? 1 : 0;
    }
}

