/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class FilterPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Supplier<? extends Predicate<? super T>> filterSupplier;

    FilterPublisher(Publisher<T> source, Supplier<? extends Predicate<? super T>> filterSupplier) {
        super(source);
        this.filterSupplier = filterSupplier;
    }

    static <T> Supplier<? extends Predicate<? super T>> newDistinctSupplier() {
        return () -> new Predicate<T>(){
            private final Set set = new HashSet();

            @Override
            public boolean test(T t) {
                return this.set.add(t);
            }
        };
    }

    static <T> Supplier<? extends Predicate<? super T>> skipWhileSupplier(final Predicate<? super T> predicate) {
        return () -> new Predicate<T>(){
            private boolean skipping = true;

            @Override
            public boolean test(T t) {
                if (this.skipping) {
                    this.skipping = predicate.test(t);
                }
                return !this.skipping;
            }
        };
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(final PublisherSource.Subscriber<? super T> subscriber) {
        return new PublisherSource.Subscriber<T>(){
            @Nullable
            private PublisherSource.Subscription subscription;
            private final Predicate<? super T> predicate;
            {
                this.predicate = (Predicate)Objects.requireNonNull(FilterPublisher.this.filterSupplier.get(), () -> "Supplier " + FilterPublisher.this.filterSupplier + " returned null");
            }

            public void onSubscribe(PublisherSource.Subscription s) {
                if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.subscription, (PublisherSource.Subscription)s)) {
                    this.subscription = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
                    subscriber.onSubscribe(this.subscription);
                }
            }

            public void onNext(T t) {
                if (this.predicate.test(t)) {
                    subscriber.onNext(t);
                } else {
                    assert (this.subscription != null);
                    this.subscription.request(1L);
                }
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
            }

            public void onComplete() {
                subscriber.onComplete();
            }
        };
    }
}

