/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.features.user;

import java.util.ArrayList;
import java.util.Map;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.ManualFeatureQueryResults;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryEnvelope;
import mil.nga.sf.proj.GeometryTransform;

public class ManualFeatureQuery {
    private final FeatureDao featureDao;
    protected int chunkLimit = 1000;
    protected double tolerance = 1.0E-14;

    public ManualFeatureQuery(FeatureDao featureDao) {
        this.featureDao = featureDao;
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public int getChunkLimit() {
        return this.chunkLimit;
    }

    public void setChunkLimit(int chunkLimit) {
        this.chunkLimit = chunkLimit;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public FeatureResultSet query() {
        return (FeatureResultSet)this.featureDao.query();
    }

    public FeatureResultSet query(boolean distinct) {
        return (FeatureResultSet)this.featureDao.query(distinct);
    }

    public FeatureResultSet query(String[] columns) {
        return (FeatureResultSet)this.featureDao.query(columns);
    }

    public FeatureResultSet query(boolean distinct, String[] columns) {
        return (FeatureResultSet)this.featureDao.query(distinct, columns);
    }

    public int count() {
        return this.featureDao.count();
    }

    public int countWithGeometries() {
        return this.featureDao.count(CoreSQLUtils.quoteWrap((String)this.featureDao.getGeometryColumnName()) + " IS NOT NULL");
    }

    public int countColumn(String column) {
        return this.featureDao.countColumn(column);
    }

    public int count(boolean distinct, String column) {
        return this.featureDao.count(distinct, column);
    }

    public FeatureResultSet query(Map<String, Object> fieldValues) {
        return this.query(false, fieldValues);
    }

    public FeatureResultSet query(boolean distinct, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.query(distinct, where, whereArgs);
    }

    public FeatureResultSet query(String[] columns, Map<String, Object> fieldValues) {
        return this.query(false, columns, fieldValues);
    }

    public FeatureResultSet query(boolean distinct, String[] columns, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.query(distinct, columns, where, whereArgs);
    }

    public int count(Map<String, Object> fieldValues) {
        return this.count(false, null, fieldValues);
    }

    public int count(String column, Map<String, Object> fieldValues) {
        return this.count(false, column, fieldValues);
    }

    public int count(boolean distinct, String column, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.featureDao.count(distinct, column, where, whereArgs);
    }

    public FeatureResultSet query(String where) {
        return (FeatureResultSet)this.featureDao.query(where);
    }

    public FeatureResultSet query(boolean distinct, String where) {
        return (FeatureResultSet)this.featureDao.query(distinct, where);
    }

    public FeatureResultSet query(String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.query(columns, where);
    }

    public FeatureResultSet query(boolean distinct, String[] columns, String where) {
        return (FeatureResultSet)this.featureDao.query(distinct, columns, where);
    }

    public int count(String where) {
        return this.featureDao.count(where);
    }

    public int count(String column, String where) {
        return this.featureDao.count(column, where);
    }

    public int count(boolean distinct, String column, String where) {
        return this.featureDao.count(distinct, column, where);
    }

    public FeatureResultSet query(String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(where, whereArgs);
    }

    public FeatureResultSet query(boolean distinct, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(distinct, where, whereArgs);
    }

    public FeatureResultSet query(String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(columns, where, whereArgs);
    }

    public FeatureResultSet query(boolean distinct, String[] columns, String where, String[] whereArgs) {
        return (FeatureResultSet)this.featureDao.query(distinct, columns, where, whereArgs);
    }

    public int count(String where, String[] whereArgs) {
        return this.featureDao.count(where, whereArgs);
    }

    public int count(String column, String where, String[] whereArgs) {
        return this.featureDao.count(column, where, whereArgs);
    }

    public int count(boolean distinct, String column, String where, String[] whereArgs) {
        return this.featureDao.count(distinct, column, where, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BoundingBox getBoundingBox() {
        GeometryEnvelope envelope = null;
        long offset = 0L;
        boolean hasResults = true;
        String[] columns = new String[]{this.featureDao.getGeometryColumnName()};
        while (hasResults) {
            hasResults = false;
            try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForChunk(columns, this.chunkLimit, offset);){
                while (resultSet.moveToNext()) {
                    hasResults = true;
                    FeatureRow featureRow = (FeatureRow)resultSet.getRow();
                    GeometryEnvelope featureEnvelope = featureRow.getGeometryEnvelope();
                    if (featureEnvelope == null) continue;
                    if (envelope == null) {
                        envelope = featureEnvelope;
                        continue;
                    }
                    envelope = envelope.union(featureEnvelope);
                }
            }
            offset += (long)this.chunkLimit;
        }
        BoundingBox boundingBox = null;
        if (envelope != null) {
            boundingBox = new BoundingBox(envelope);
        }
        return boundingBox;
    }

    public BoundingBox getBoundingBox(Projection projection) {
        BoundingBox boundingBox = this.getBoundingBox();
        if (boundingBox != null && projection != null) {
            GeometryTransform projectionTransform = GeometryTransform.create((Projection)this.featureDao.getProjection(), (Projection)projection);
            boundingBox = boundingBox.transform(projectionTransform);
        }
        return boundingBox;
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox) {
        return this.query(false, boundingBox);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox) {
        return this.query(distinct, boundingBox.buildEnvelope());
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox) {
        return this.query(false, columns, boundingBox);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox) {
        return this.query(distinct, columns, boundingBox.buildEnvelope());
    }

    public long count(BoundingBox boundingBox) {
        return this.count(boundingBox.buildEnvelope());
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(false, boundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(distinct, boundingBox.buildEnvelope(), fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(false, columns, boundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.query(distinct, columns, boundingBox.buildEnvelope(), fieldValues);
    }

    public long count(BoundingBox boundingBox, Map<String, Object> fieldValues) {
        return this.count(boundingBox.buildEnvelope(), fieldValues);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, String where) {
        return this.query(false, boundingBox, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, String where) {
        return this.query(distinct, boundingBox, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, String where) {
        return this.query(false, columns, boundingBox, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, String where) {
        return this.query(distinct, columns, boundingBox, where, null);
    }

    public long count(BoundingBox boundingBox, String where) {
        return this.count(boundingBox, where, null);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(false, boundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(distinct, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(false, columns, boundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.query(distinct, columns, boundingBox.buildEnvelope(), where, whereArgs);
    }

    public long count(BoundingBox boundingBox, String where, String[] whereArgs) {
        return this.count(boundingBox.buildEnvelope(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection) {
        return this.query(false, boundingBox, projection);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection) {
        return this.query(false, columns, boundingBox, projection);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox);
    }

    public long count(BoundingBox boundingBox, Projection projection) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.query(false, boundingBox, projection, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        return this.query(false, columns, boundingBox, projection, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox, fieldValues);
    }

    public long count(BoundingBox boundingBox, Projection projection, Map<String, Object> fieldValues) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, fieldValues);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, String where) {
        return this.query(false, boundingBox, projection, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(distinct, boundingBox, projection, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(false, columns, boundingBox, projection, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where) {
        return this.query(distinct, columns, boundingBox, projection, where, null);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where) {
        return this.count(boundingBox, projection, where, null);
    }

    public ManualFeatureQueryResults query(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.query(false, boundingBox, projection, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, featureBoundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        return this.query(false, columns, boundingBox, projection, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.query(distinct, columns, featureBoundingBox, where, whereArgs);
    }

    public long count(BoundingBox boundingBox, Projection projection, String where, String[] whereArgs) {
        BoundingBox featureBoundingBox = this.featureDao.projectBoundingBox(boundingBox, projection);
        return this.count(featureBoundingBox, where, whereArgs);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope) {
        return this.query(false, envelope);
    }

    public ManualFeatureQueryResults query(boolean distinct, GeometryEnvelope envelope) {
        return this.query(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope) {
        return this.query(false, columns, envelope);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, GeometryEnvelope envelope) {
        return this.query(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public long count(GeometryEnvelope envelope) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY());
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(false, envelope, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(false, columns, envelope, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.query(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public long count(GeometryEnvelope envelope, Map<String, Object> fieldValues) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), fieldValues);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, String where) {
        return this.query(false, envelope, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, GeometryEnvelope envelope, String where) {
        return this.query(distinct, envelope, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(false, columns, envelope, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, String where) {
        return this.query(distinct, columns, envelope, where, null);
    }

    public long count(GeometryEnvelope envelope, String where) {
        return this.count(envelope, where, null);
    }

    public ManualFeatureQueryResults query(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(false, envelope, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(distinct, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(false, columns, envelope, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.query(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public long count(GeometryEnvelope envelope, String where, String[] whereArgs) {
        return this.count(envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY) {
        return this.query(false, minX, minY, maxX, maxY);
    }

    public ManualFeatureQueryResults query(boolean distinct, double minX, double minY, double maxX, double maxY) {
        return this.query(distinct, minX, minY, maxX, maxY, null, null);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY) {
        return this.query(false, columns, minX, minY, maxX, maxY);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY) {
        return this.query(distinct, columns, minX, minY, maxX, maxY, null, null);
    }

    public long count(double minX, double minY, double maxX, double maxY) {
        return this.query(minX, minY, maxX, maxY).count();
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.query(false, minX, minY, maxX, maxY, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        return this.query(false, columns, minX, minY, maxX, maxY, fieldValues);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.query(distinct, columns, minX, minY, maxX, maxY, where, whereArgs);
    }

    public long count(double minX, double minY, double maxX, double maxY, Map<String, Object> fieldValues) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return this.count(minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, String where) {
        return this.query(false, minX, minY, maxX, maxY, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, double minX, double minY, double maxX, double maxY, String where) {
        return this.query(distinct, minX, minY, maxX, maxY, where, null);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.query(false, columns, minX, minY, maxX, maxY, where);
    }

    public ManualFeatureQueryResults query(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where) {
        return this.query(distinct, columns, minX, minY, maxX, maxY, where, null);
    }

    public long count(double minX, double minY, double maxX, double maxY, String where) {
        return this.count(minX, minY, maxX, maxY, where, null);
    }

    public ManualFeatureQueryResults query(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(false, minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(boolean distinct, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(distinct, this.featureDao.getColumnNames(), minX, minY, maxX, maxY, where, whereArgs);
    }

    public ManualFeatureQueryResults query(String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(false, columns, minX, minY, maxX, maxY, where, whereArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManualFeatureQueryResults query(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        ArrayList<Long> featureIds = new ArrayList<Long>();
        long offset = 0L;
        boolean hasResults = true;
        minX -= this.tolerance;
        maxX += this.tolerance;
        minY -= this.tolerance;
        maxY += this.tolerance;
        String[] queryColumns = this.featureDao.getIdAndGeometryColumnNames();
        while (hasResults) {
            hasResults = false;
            try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForChunk(distinct, queryColumns, where, whereArgs, this.chunkLimit, offset);){
                while (resultSet.moveToNext()) {
                    hasResults = true;
                    FeatureRow featureRow = (FeatureRow)resultSet.getRow();
                    GeometryEnvelope envelope = featureRow.getGeometryEnvelope();
                    if (envelope == null) continue;
                    double minXMax = Math.max(minX, envelope.getMinX());
                    double maxXMin = Math.min(maxX, envelope.getMaxX());
                    double minYMax = Math.max(minY, envelope.getMinY());
                    double maxYMin = Math.min(maxY, envelope.getMaxY());
                    if (!(minXMax <= maxXMin) || !(minYMax <= maxYMin)) continue;
                    featureIds.add(featureRow.getId());
                }
            }
            offset += (long)this.chunkLimit;
        }
        ManualFeatureQueryResults results = new ManualFeatureQueryResults(this.featureDao, columns, featureIds);
        return results;
    }

    public long count(double minX, double minY, double maxX, double maxY, String where, String[] whereArgs) {
        return this.query(minX, minY, maxX, maxY, where, whereArgs).count();
    }

    public FeatureResultSet queryForChunk(int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(limit);
    }

    public FeatureResultSet queryForChunk(int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(limit, offset);
    }

    public FeatureResultSet queryForChunk(String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(false, fieldValues, limit);
    }

    public FeatureResultSet queryForChunk(Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(false, fieldValues, limit, offset);
    }

    public FeatureResultSet queryForChunk(Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, Map<String, Object> fieldValues, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, Map<String, Object> fieldValues, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, Map<String, Object> fieldValues, int limit) {
        return this.queryForChunk(false, columns, fieldValues, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        return this.queryForChunk(false, columns, fieldValues, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        return this.queryForChunk(false, columns, fieldValues, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        return this.queryForChunk(false, columns, fieldValues, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, whereArgs, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, whereArgs, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, Map<String, Object> fieldValues, String orderBy, int limit, long offset) {
        String where = this.featureDao.buildWhere(fieldValues.entrySet());
        String[] whereArgs = this.featureDao.buildWhereArgs(fieldValues.values());
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunkWhere(String where, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, new String[0], limit);
    }

    public FeatureResultSet queryForChunkWhere(String where, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, new String[0], limit, offset);
    }

    public FeatureResultSet queryForChunk(String where, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, new String[0], orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String where, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, new String[0], orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunkWhere(boolean distinct, String where, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, new String[0], limit);
    }

    public FeatureResultSet queryForChunkWhere(boolean distinct, String where, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, new String[0], limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, new String[0], orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, new String[0], orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunkWhere(String[] columns, String where, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, new String[0], limit);
    }

    public FeatureResultSet queryForChunkWhere(String[] columns, String where, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, new String[0], limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, new String[0], orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, new String[0], orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunkWhere(boolean distinct, String[] columns, String where, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, new String[0], limit);
    }

    public FeatureResultSet queryForChunkWhere(boolean distinct, String[] columns, String where, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, new String[0], limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, new String[0], orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, String where, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, new String[0], orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(String where, String[] whereArgs, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, whereArgs, limit);
    }

    public FeatureResultSet queryForChunk(String where, String[] whereArgs, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, whereArgs, limit, offset);
    }

    public FeatureResultSet queryForChunk(String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String[] whereArgs, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String[] whereArgs, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String[] whereArgs, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, whereArgs, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String[] whereArgs, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, whereArgs, limit, offset);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, whereArgs, orderBy, limit);
    }

    public FeatureResultSet queryForChunk(String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(columns, where, whereArgs, orderBy, limit, offset);
    }

    public FeatureResultSet queryForChunk(boolean distinct, String[] columns, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return (FeatureResultSet)this.featureDao.queryForChunk(distinct, columns, where, whereArgs, orderBy, limit, offset);
    }

    public ManualFeatureQueryResults queryForChunk(boolean distinct, String[] columns, GeometryEnvelope envelope, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        return this.queryForChunk(distinct, columns, envelope.getMinX(), envelope.getMinY(), envelope.getMaxX(), envelope.getMaxY(), where, whereArgs, orderBy, limit, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManualFeatureQueryResults queryForChunk(boolean distinct, String[] columns, double minX, double minY, double maxX, double maxY, String where, String[] whereArgs, String orderBy, int limit, long offset) {
        int index = 0;
        ArrayList<Long> featureIds = new ArrayList<Long>();
        long localOffset = 0L;
        boolean hasResults = true;
        minX -= this.tolerance;
        maxX += this.tolerance;
        minY -= this.tolerance;
        maxY += this.tolerance;
        String[] queryColumns = this.featureDao.getIdAndGeometryColumnNames();
        while (hasResults) {
            hasResults = false;
            try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForChunk(distinct, queryColumns, where, whereArgs, this.chunkLimit, localOffset);){
                while (resultSet.moveToNext()) {
                    hasResults = true;
                    FeatureRow featureRow = (FeatureRow)resultSet.getRow();
                    GeometryEnvelope envelope = featureRow.getGeometryEnvelope();
                    if (envelope == null) continue;
                    double minXMax = Math.max(minX, envelope.getMinX());
                    double maxXMin = Math.min(maxX, envelope.getMaxX());
                    double minYMax = Math.max(minY, envelope.getMinY());
                    double maxYMin = Math.min(maxY, envelope.getMaxY());
                    if (!(minXMax <= maxXMin) || !(minYMax <= maxYMin)) continue;
                    if (offset <= (long)index) {
                        featureIds.add(featureRow.getId());
                        if (featureIds.size() >= limit) {
                            break;
                        }
                    }
                    ++index;
                }
            }
            localOffset += (long)this.chunkLimit;
        }
        ManualFeatureQueryResults results = new ManualFeatureQueryResults(this.featureDao, columns, featureIds);
        return results;
    }
}

