/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.util.Collection;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.extension.nga.link.FeatureTileTableLinker;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileGenerator;
import mil.nga.geopackage.tiles.TileGrid;
import mil.nga.geopackage.tiles.features.FeatureTiles;
import mil.nga.proj.Projection;
import mil.nga.sf.proj.GeometryTransform;

public class FeatureTileGenerator
extends TileGenerator {
    private final FeatureTiles featureTiles;
    private boolean linkTables = true;

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int zoomLevel, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, zoomLevel, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, minZoom, maxZoom, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, Collection<Integer> zoomLevels, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, zoomLevels, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int[] zoomLevels, BoundingBox boundingBox, Projection projection) {
        this(geoPackage, tableName, featureTiles, geoPackage, zoomLevels, boundingBox, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int zoomLevel, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, zoomLevel, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int minZoom, int maxZoom, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, minZoom, maxZoom, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, Collection<Integer> zoomLevels, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, zoomLevels, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int[] zoomLevels, BoundingBox boundingBox, Projection projection) {
        super(geoPackage, tableName, zoomLevels, FeatureTileGenerator.getBoundingBox(featureGeoPackage, featureTiles, boundingBox, projection), projection);
        this.featureTiles = featureTiles;
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, Projection projection) {
        this(geoPackage, tableName, featureTiles, new int[0], null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int zoomLevel, Projection projection) {
        this(geoPackage, tableName, featureTiles, zoomLevel, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int minZoom, int maxZoom, Projection projection) {
        this(geoPackage, tableName, featureTiles, minZoom, maxZoom, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, Collection<Integer> zoomLevels, Projection projection) {
        this(geoPackage, tableName, featureTiles, zoomLevels, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, int[] zoomLevels, Projection projection) {
        this(geoPackage, tableName, featureTiles, zoomLevels, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, new int[0], null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int zoomLevel, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, zoomLevel, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int minZoom, int maxZoom, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, minZoom, maxZoom, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, Collection<Integer> zoomLevels, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, zoomLevels, null, projection);
    }

    public FeatureTileGenerator(GeoPackage geoPackage, String tableName, FeatureTiles featureTiles, GeoPackage featureGeoPackage, int[] zoomLevels, Projection projection) {
        this(geoPackage, tableName, featureTiles, featureGeoPackage, zoomLevels, null, projection);
    }

    private static BoundingBox getBoundingBox(GeoPackage geoPackage, FeatureTiles featureTiles, BoundingBox boundingBox, Projection projection) {
        boolean manualQuery;
        String tableName = featureTiles.getFeatureDao().getTableName();
        BoundingBox featureBoundingBox = geoPackage.getBoundingBox(projection, tableName, manualQuery = boundingBox == null);
        if (featureBoundingBox != null) {
            boundingBox = boundingBox == null ? featureBoundingBox : boundingBox.overlap(featureBoundingBox);
        }
        if (boundingBox != null) {
            boundingBox = featureTiles.expandBoundingBox(boundingBox, projection);
        }
        return boundingBox;
    }

    @Override
    public BoundingBox getBoundingBox(int zoom) {
        GeometryTransform projectionToWebMercator = GeometryTransform.create((Projection)this.projection, (long)3857L);
        BoundingBox webMercatorBoundingBox = this.boundingBox.transform(projectionToWebMercator);
        TileGrid tileGrid = TileBoundingBoxUtils.getTileGrid((BoundingBox)webMercatorBoundingBox, (long)zoom);
        BoundingBox tileBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)tileGrid.getMinX(), (long)tileGrid.getMinY(), (long)zoom);
        BoundingBox expandedBoundingBox = this.featureTiles.expandBoundingBox(webMercatorBoundingBox, tileBoundingBox);
        BoundingBox zoomBoundingBox = expandedBoundingBox.transform(projectionToWebMercator.getInverseTransformation());
        return zoomBoundingBox;
    }

    public boolean isLinkTables() {
        return this.linkTables;
    }

    public void setLinkTables(boolean linkTables) {
        this.linkTables = linkTables;
    }

    @Override
    protected void preTileGeneration() {
        GeoPackage geoPackage = this.getGeoPackage();
        String featureTable = this.featureTiles.getFeatureDao().getTableName();
        String tileTable = this.getTableName();
        if (this.linkTables && geoPackage.isFeatureTable(featureTable) && geoPackage.isTileTable(tileTable)) {
            FeatureTileTableLinker linker = new FeatureTileTableLinker(geoPackage);
            linker.link(featureTable, tileTable);
        }
    }

    @Override
    protected byte[] createTile(int z, long x, long y) {
        byte[] tileData = this.featureTiles.drawTileBytes((int)x, (int)y, z);
        return tileData;
    }
}

