/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.Link;

@JsonTypeName(value="style")
public class Style {
    @Valid
    private String id;
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<String> keywords = null;
    @Valid
    private List<Link> links = null;

    public Style id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="An identifier for this style. Implementation of 'identifier'")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Style title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="A title for this style")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Style description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Brief narrative description of this style")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Style keywords(List<String> keywords) {
        this.keywords = keywords;
        return this;
    }

    @ApiModelProperty(value="keywords about this style")
    @JsonProperty(value="keywords")
    public List<String> getKeywords() {
        return this.keywords;
    }

    @JsonProperty(value="keywords")
    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public Style addKeywordsItem(String keywordsItem) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keywordsItem);
        return this;
    }

    public Style removeKeywordsItem(String keywordsItem) {
        if (keywordsItem != null && this.keywords != null) {
            this.keywords.remove(keywordsItem);
        }
        return this;
    }

    public Style links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="Links to style related resources. Possible link 'rel' values are: 'style' for a URL pointing to the style description, 'styleSpec' for a URL pointing to the specification or standard used to define the style.")
    @JsonProperty(value="links")
    @Size(min=1)
    public @Size(min=1) List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Style addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public Style removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Style style = (Style)o;
        return Objects.equals(this.id, style.id) && Objects.equals(this.title, style.title) && Objects.equals(this.description, style.description) && Objects.equals(this.keywords, style.keywords) && Objects.equals(this.links, style.links);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.keywords, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Style {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    keywords: ").append(this.toIndentedString(this.keywords)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

