/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.requests.ImmutableRegisterTableRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.util.JsonUtil;

public class RegisterTableRequestParser {
    private static final String NAME = "name";
    private static final String METADATA_LOCATION = "metadata-location";

    private RegisterTableRequestParser() {
    }

    public static String toJson(RegisterTableRequest request) {
        return RegisterTableRequestParser.toJson(request, false);
    }

    public static String toJson(RegisterTableRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> RegisterTableRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(RegisterTableRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid register table request: null");
        gen.writeStartObject();
        gen.writeStringField(NAME, request.name());
        gen.writeStringField(METADATA_LOCATION, request.metadataLocation());
        gen.writeEndObject();
    }

    public static RegisterTableRequest fromJson(String json) {
        return JsonUtil.parse(json, RegisterTableRequestParser::fromJson);
    }

    public static RegisterTableRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse register table request from null object");
        String name = JsonUtil.getString(NAME, json);
        String metadataLocation = JsonUtil.getString(METADATA_LOCATION, json);
        return ImmutableRegisterTableRequest.builder().name(name).metadataLocation(metadataLocation).build();
    }
}

