/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.security.SecureRandom;
import org.apache.commons.codec.digest.DigestUtils;

public class PolarisPrincipalSecrets {
    private static final SecureRandom secureRandom = new SecureRandom();
    private final long principalId;
    private final String principalClientId;
    private String mainSecret;
    private String secondarySecret;
    private String mainSecretHash;
    private String secondarySecretHash;
    private String secretSalt;

    private String generateRandomHexString(int stringLength) {
        byte[] randomBytes = new byte[stringLength / 2];
        secureRandom.nextBytes(randomBytes);
        StringBuilder sb = new StringBuilder();
        for (byte randomByte : randomBytes) {
            sb.append(String.format("%02x", randomByte));
        }
        return sb.toString();
    }

    private String hashSecret(String secret) {
        return DigestUtils.sha256Hex((String)(secret + ":" + this.secretSalt));
    }

    @JsonCreator
    public PolarisPrincipalSecrets(@JsonProperty(value="principalId") long principalId, @JsonProperty(value="principalClientId") String principalClientId, @JsonProperty(value="mainSecret") String mainSecret, @JsonProperty(value="secondarySecret") String secondarySecret, @JsonProperty(value="secretSalt") String secretSalt, @JsonProperty(value="mainSecretHash") String mainSecretHash, @JsonProperty(value="secondarySecretHash") String secondarySecretHash) {
        this.principalId = principalId;
        this.principalClientId = principalClientId;
        this.mainSecret = mainSecret;
        this.secondarySecret = secondarySecret;
        this.secretSalt = secretSalt;
        if (this.secretSalt == null) {
            this.secretSalt = this.generateRandomHexString(16);
        }
        this.mainSecretHash = mainSecretHash;
        if (this.mainSecretHash == null) {
            this.mainSecretHash = this.hashSecret(mainSecret);
        }
        this.secondarySecretHash = secondarySecretHash;
        if (this.secondarySecretHash == null) {
            this.secondarySecretHash = this.hashSecret(secondarySecret);
        }
    }

    public PolarisPrincipalSecrets(long principalId, String principalClientId, String mainSecret, String secondarySecret) {
        this.principalId = principalId;
        this.principalClientId = principalClientId;
        this.mainSecret = mainSecret;
        this.secondarySecret = secondarySecret;
        this.secretSalt = this.generateRandomHexString(16);
        this.mainSecretHash = this.hashSecret(mainSecret);
        this.secondarySecretHash = this.hashSecret(secondarySecret);
    }

    public PolarisPrincipalSecrets(PolarisPrincipalSecrets principalSecrets) {
        this.principalId = principalSecrets.getPrincipalId();
        this.principalClientId = principalSecrets.getPrincipalClientId();
        this.mainSecret = principalSecrets.getMainSecret();
        this.secondarySecret = principalSecrets.getSecondarySecret();
        this.secretSalt = principalSecrets.getSecretSalt();
        this.mainSecretHash = principalSecrets.getMainSecretHash();
        this.secondarySecretHash = principalSecrets.getSecondarySecretHash();
    }

    public PolarisPrincipalSecrets(long principalId) {
        this.principalId = principalId;
        this.principalClientId = this.generateRandomHexString(16);
        this.mainSecret = this.generateRandomHexString(32);
        this.secondarySecret = this.generateRandomHexString(32);
        this.secretSalt = this.generateRandomHexString(16);
        this.mainSecretHash = this.hashSecret(this.mainSecret);
        this.secondarySecretHash = this.hashSecret(this.secondarySecret);
    }

    public void rotateSecrets(String newSecondaryHash) {
        this.secondarySecret = null;
        this.secondarySecretHash = newSecondaryHash;
        this.mainSecret = this.generateRandomHexString(32);
        this.mainSecretHash = this.hashSecret(this.mainSecret);
    }

    public long getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalClientId() {
        return this.principalClientId;
    }

    public boolean matchesSecret(String potentialSecret) {
        String potentialSecretHash = this.hashSecret(potentialSecret);
        return potentialSecretHash.equals(this.mainSecretHash) || potentialSecretHash.equals(this.secondarySecretHash);
    }

    public String getMainSecret() {
        return this.mainSecret;
    }

    public String getSecondarySecret() {
        return this.secondarySecret;
    }

    public String getMainSecretHash() {
        return this.mainSecretHash;
    }

    public String getSecondarySecretHash() {
        return this.secondarySecretHash;
    }

    public String getSecretSalt() {
        return this.secretSalt;
    }
}

