/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.auth;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.polaris.core.auth.PolarisPrincipal;
import org.immutables.value.Generated;

@Generated(from="PolarisPrincipal", generator="Immutables")
public final class ImmutablePolarisPrincipal
implements PolarisPrincipal {
    private final String name;
    private final long id;
    private final ImmutableSet<String> roles;
    private final ImmutableMap<String, String> properties;
    private transient int hashCode;

    private ImmutablePolarisPrincipal(String name, long id, ImmutableSet<String> roles, ImmutableMap<String, String> properties) {
        this.name = name;
        this.id = id;
        this.roles = roles;
        this.properties = properties;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public ImmutableSet<String> getRoles() {
        return this.roles;
    }

    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public final ImmutablePolarisPrincipal withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePolarisPrincipal(newValue, this.id, this.roles, this.properties);
    }

    public final ImmutablePolarisPrincipal withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutablePolarisPrincipal(this.name, value, this.roles, this.properties);
    }

    public final ImmutablePolarisPrincipal withRoles(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ImmutablePolarisPrincipal(this.name, this.id, (ImmutableSet<String>)newValue, this.properties);
    }

    public final ImmutablePolarisPrincipal withRoles(Iterable<String> elements) {
        if (this.roles == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ImmutablePolarisPrincipal(this.name, this.id, (ImmutableSet<String>)newValue, this.properties);
    }

    public final ImmutablePolarisPrincipal withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePolarisPrincipal(this.name, this.id, this.roles, (ImmutableMap<String, String>)newValue);
    }

    @Override
    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePolarisPrincipal && this.equalsByValue((ImmutablePolarisPrincipal)another);
    }

    private boolean equalsByValue(ImmutablePolarisPrincipal another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.id == another.id && this.roles.equals(another.roles) && this.properties.equals(another.properties);
    }

    @Override
    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.id);
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((String)"PolarisPrincipal").omitNullValues().add("name", (Object)this.name).add("id", this.id).add("roles", this.roles).add("properties", this.properties).toString();
    }

    public static ImmutablePolarisPrincipal copyOf(PolarisPrincipal instance) {
        if (instance instanceof ImmutablePolarisPrincipal) {
            return (ImmutablePolarisPrincipal)instance;
        }
        return ImmutablePolarisPrincipal.builder().from(instance).build();
    }

    public Builder toBuilder() {
        return ImmutablePolarisPrincipal.builder().from(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PolarisPrincipal", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        private String name;
        private long id;
        private ImmutableSet.Builder<String> roles = ImmutableSet.builder();
        private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Principal instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PolarisPrincipal instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            Principal instance;
            long bits = 0L;
            if (object instanceof Principal) {
                instance = (Principal)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
            }
            if (object instanceof PolarisPrincipal) {
                instance = (PolarisPrincipal)object;
                if ((bits & 1L) == 0L) {
                    this.name(instance.getName());
                    bits |= 1L;
                }
                this.id(instance.getId());
                this.putAllProperties(instance.getProperties());
                this.addAllRoles(instance.getRoles());
            }
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRole(String element) {
            this.roles.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRoles(String ... elements) {
            this.roles.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder roles(Iterable<String> elements) {
            this.roles = ImmutableSet.builder();
            return this.addAllRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRoles(Iterable<String> elements) {
            this.roles.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperty(String key, String value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperty(Map.Entry<String, ? extends String> entry) {
            this.properties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            this.properties.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.name = null;
            this.id = 0L;
            this.roles = ImmutableSet.builder();
            this.properties = ImmutableMap.builder();
            return this;
        }

        public ImmutablePolarisPrincipal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePolarisPrincipal(this.name, this.id, (ImmutableSet<String>)this.roles.build(), (ImmutableMap<String, String>)this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build PolarisPrincipal, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

