/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.pipes;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.pipes.PipesPartitioner;
import org.apache.hadoop.mapred.pipes.UpwardProtocol;

class OutputHandler<K extends WritableComparable, V extends Writable>
implements UpwardProtocol<K, V> {
    private Reporter reporter;
    private OutputCollector<K, V> collector;
    private float progressValue = 0.0f;
    private boolean done = false;
    private Throwable exception = null;
    RecordReader<FloatWritable, NullWritable> recordReader = null;
    private Map<Integer, Counters.Counter> registeredCounters = new HashMap<Integer, Counters.Counter>();
    private String expectedDigest = null;
    private boolean digestReceived = false;
    private FloatWritable progressKey = new FloatWritable(0.0f);
    private NullWritable nullValue = NullWritable.get();

    public OutputHandler(OutputCollector<K, V> collector, Reporter reporter, RecordReader<FloatWritable, NullWritable> recordReader, String expectedDigest) {
        this.reporter = reporter;
        this.collector = collector;
        this.recordReader = recordReader;
        this.expectedDigest = expectedDigest;
    }

    @Override
    public void output(K key, V value) throws IOException {
        this.collector.collect(key, value);
    }

    @Override
    public void partitionedOutput(int reduce, K key, V value) throws IOException {
        PipesPartitioner.setNextPartition(reduce);
        this.collector.collect(key, value);
    }

    @Override
    public void status(String msg) {
        this.reporter.setStatus(msg);
    }

    @Override
    public void progress(float progress) throws IOException {
        this.progressValue = progress;
        this.reporter.progress();
        if (this.recordReader != null) {
            this.progressKey.set(progress);
            this.recordReader.next(this.progressKey, this.nullValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done() throws IOException {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.done = true;
            this.notify();
        }
    }

    public float getProgress() {
        return this.progressValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void failed(Throwable e) {
        OutputHandler outputHandler = this;
        synchronized (outputHandler) {
            this.exception = e;
            this.notify();
        }
    }

    public synchronized boolean waitForFinish() throws Throwable {
        while (!this.done && this.exception == null) {
            this.wait();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.done;
    }

    @Override
    public void registerCounter(int id, String group, String name) throws IOException {
        Counters.Counter counter = this.reporter.getCounter(group, name);
        this.registeredCounters.put(id, counter);
    }

    @Override
    public void incrementCounter(int id, long amount) throws IOException {
        if (id >= this.registeredCounters.size()) {
            throw new IOException("Invalid counter with id: " + id);
        }
        Counters.Counter counter = this.registeredCounters.get(id);
        counter.increment(amount);
    }

    @Override
    public synchronized boolean authenticate(String digest) throws IOException {
        boolean success = true;
        if (!this.expectedDigest.equals(digest)) {
            this.exception = new IOException("Authentication Failed: Expected digest=" + this.expectedDigest + ", received=" + this.digestReceived);
            success = false;
        }
        this.digestReceived = true;
        this.notify();
        return success;
    }

    synchronized void waitForAuthentication() throws IOException, InterruptedException {
        while (!this.digestReceived && this.exception == null) {
            this.wait();
        }
        if (this.exception != null) {
            throw new IOException(this.exception.getMessage());
        }
    }
}

