/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.basicconfig.ConfigUtil;
import io.smallrye.faulttolerance.config.FallbackConfig;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public final class FallbackConfigImpl
implements FallbackConfig {
    private final Class<?> beanClass;
    private final MethodDescriptor method;
    private final boolean onMethod;
    private final String description;
    private final String configKey;
    private final Fallback instance;
    private Class<? extends FallbackHandler<?>> _value;
    private String _fallbackMethod;
    private Class<? extends Throwable>[] _applyOn;
    private Class<? extends Throwable>[] _skipOn;

    private FallbackConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.onMethod = method.annotationsPresentDirectly.contains(Fallback.class);
        this.description = method.method.toString();
        this.configKey = this.onMethod ? method.method.declaringClass.getName() + "/" + method.method.name : method.method.declaringClass.getName();
        this.instance = method.fallback;
    }

    public static FallbackConfigImpl create(FaultToleranceMethod method) {
        if (method.fallback == null) {
            return null;
        }
        if (!ConfigUtil.isEnabled((String)"fallback.enabled", (String)"Fallback/enabled", (MethodDescriptor)method.method)) {
            return null;
        }
        return new FallbackConfigImpl(method);
    }

    public boolean isOnMethod() {
        return this.onMethod;
    }

    public Class<?> beanClass() {
        return this.beanClass;
    }

    public MethodDescriptor method() {
        return this.method;
    }

    public Class<? extends Annotation> annotationType() {
        return Fallback.class;
    }

    public Class<? extends FallbackHandler<?>> value() {
        if (this._value == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.value";
            Object oldKey = this.configKey + "/Fallback/value";
            this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> FallbackConfigImpl.lambda$value$0(config, (String)oldKey)).orElse(null);
            if (this._value == null) {
                newKey = "smallrye.faulttolerance.global.fallback.value";
                oldKey = "Fallback/value";
                this._value = config.getOptionalValue((String)newKey, Class.class).or(() -> FallbackConfigImpl.lambda$value$1(config, (String)oldKey)).orElse(null);
            }
            if (this._value == null) {
                this._value = this.instance.value();
            }
        }
        return this._value;
    }

    public String fallbackMethod() {
        if (this._fallbackMethod == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.fallback-method";
            Object oldKey = this.configKey + "/Fallback/fallbackMethod";
            this._fallbackMethod = config.getOptionalValue((String)newKey, String.class).or(() -> FallbackConfigImpl.lambda$fallbackMethod$2(config, (String)oldKey)).orElse(null);
            if (this._fallbackMethod == null) {
                newKey = "smallrye.faulttolerance.global.fallback.fallback-method";
                oldKey = "Fallback/fallbackMethod";
                this._fallbackMethod = config.getOptionalValue((String)newKey, String.class).or(() -> FallbackConfigImpl.lambda$fallbackMethod$3(config, (String)oldKey)).orElse(null);
            }
            if (this._fallbackMethod == null) {
                this._fallbackMethod = this.instance.fallbackMethod();
            }
        }
        return this._fallbackMethod;
    }

    public Class<? extends Throwable>[] applyOn() {
        if (this._applyOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.apply-on";
            Object oldKey = this.configKey + "/Fallback/applyOn";
            this._applyOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> FallbackConfigImpl.lambda$applyOn$4(config, (String)oldKey)).orElse(null);
            if (this._applyOn == null) {
                newKey = "smallrye.faulttolerance.global.fallback.apply-on";
                oldKey = "Fallback/applyOn";
                this._applyOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> FallbackConfigImpl.lambda$applyOn$5(config, (String)oldKey)).orElse(null);
            }
            if (this._applyOn == null) {
                this._applyOn = this.instance.applyOn();
            }
        }
        return this._applyOn;
    }

    public Class<? extends Throwable>[] skipOn() {
        if (this._skipOn == null) {
            Config config = ConfigProvider.getConfig();
            Object newKey = "smallrye.faulttolerance.\"" + this.configKey + "\".fallback.skip-on";
            Object oldKey = this.configKey + "/Fallback/skipOn";
            this._skipOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> FallbackConfigImpl.lambda$skipOn$6(config, (String)oldKey)).orElse(null);
            if (this._skipOn == null) {
                newKey = "smallrye.faulttolerance.global.fallback.skip-on";
                oldKey = "Fallback/skipOn";
                this._skipOn = config.getOptionalValue((String)newKey, Class[].class).or(() -> FallbackConfigImpl.lambda$skipOn$7(config, (String)oldKey)).orElse(null);
            }
            if (this._skipOn == null) {
                this._skipOn = this.instance.skipOn();
            }
        }
        return this._skipOn;
    }

    public void materialize() {
        this.value();
        this.fallbackMethod();
        this.applyOn();
        this.skipOn();
    }

    public FaultToleranceDefinitionException fail(String reason) {
        return new FaultToleranceDefinitionException("Invalid @Fallback on " + this.description + ": " + reason);
    }

    public FaultToleranceDefinitionException fail(String member, String reason) {
        return new FaultToleranceDefinitionException("Invalid @Fallback." + member + " on " + this.description + ": " + reason);
    }

    private static /* synthetic */ Optional lambda$skipOn$7(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$skipOn$6(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$applyOn$5(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$applyOn$4(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class[].class);
    }

    private static /* synthetic */ Optional lambda$fallbackMethod$3(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }

    private static /* synthetic */ Optional lambda$fallbackMethod$2(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, String.class);
    }

    private static /* synthetic */ Optional lambda$value$1(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }

    private static /* synthetic */ Optional lambda$value$0(Config config, String oldKey) {
        return config.getOptionalValue(oldKey, Class.class);
    }
}

