/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FullyQualifyPathExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;

public final class UpdateStatement
extends AbstractExpression {
    private boolean hasSpaceAfterUpdateClause;
    private UpdateClause updateClause;
    private AbstractExpression whereClause;

    public UpdateStatement(AbstractExpression parent) {
        super(parent);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getUpdateClause().accept(visitor);
        this.getWhereClause().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getUpdateClause());
        children.add(this.getWhereClause());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.updateClause);
        if (this.hasSpaceAfterUpdateClause) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whereClause != null) {
            children.add(this.whereClause);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.updateClause.isAncestor(expression)) {
            return this.getQueryBNF("update_clause");
        }
        if (this.whereClause != null && this.whereClause.isAncestor(expression)) {
            return this.getQueryBNF("where_clause");
        }
        return super.findQueryBNF(expression);
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("update_statement");
    }

    public UpdateClause getUpdateClause() {
        return this.updateClause;
    }

    public Expression getWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = this.buildNullExpression();
        }
        return this.whereClause;
    }

    public boolean hasSpaceAfterUpdateClause() {
        return this.hasSpaceAfterUpdateClause;
    }

    public boolean hasWhereClause() {
        return this.whereClause != null && !this.whereClause.isNull();
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.updateClause = new UpdateClause(this);
        this.updateClause.parse(wordParser, tolerant);
        boolean bl = this.hasSpaceAfterUpdateClause = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("WHERE")) {
            this.whereClause = new WhereClause(this);
            this.whereClause.parse(wordParser, tolerant);
        }
        this.accept(new FullyQualifyPathExpressionVisitor());
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        this.updateClause.toParsedText(writer, actual);
        if (this.hasSpaceAfterUpdateClause) {
            writer.append(' ');
        }
        if (this.whereClause != null) {
            this.whereClause.toParsedText(writer, actual);
        }
    }
}

