/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.amazon.common.runtime;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.Timer;
import java.util.Arrays;
import java.util.function.BooleanSupplier;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;

public class OtelOldSubstitutions {
    static final String SOFTWARE_AMAZON_AWSSDK_SQS_PACKAGE = "software.amazon.awssdk.services.sqs";
    static final String SOFTWARE_AMAZON_AWSSDK_SNS_PACKAGE = "software.amazon.awssdk.services.sns";
    static final String IO_OPENTELEMETRY_INSTRUMENTATION_AWSSDK_V2_2_PACKAGE = "io.opentelemetry.instrumentation.awssdk.v2_2";
    static final String IO_OPENTELEMETRY_INSTRUMENTATION_AWSSDK_V2_2_INTERNAL_PACKAGE = "io.opentelemetry.instrumentation.awssdk.v2_2.internal";

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess", onlyWith={IsSqsPresent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Target_SqsAccess_Present {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
        private static boolean enabled = true;

        Target_SqsAccess_Present() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SnsAccess", onlyWith={IsSnsPresent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Target_SnsAccess_Present {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
        private static boolean enabled = true;

        Target_SnsAccess_Present() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SnsAccess", onlyWith={IsSnsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Target_SnsAccess {
        @Delete
        private static boolean enabled;

        Target_SnsAccess() {
        }

        @Substitute
        public static SdkRequest modifyRequest(SdkRequest request, Context otelContext, TextMapPropagator messagingPropagator) {
            return null;
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SnsImpl", onlyWith={IsSnsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SnsImpl {
        Delete_SnsImpl() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.TracingList", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_TracingList {
        Delete_TracingList() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.TracingIterator", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_TracingIterator {
        Delete_TracingIterator() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsTracingContext", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsTracingContext {
        Delete_SqsTracingContext() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequestAttributesGetter", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsReceiveRequestAttributesGetter {
        Delete_SqsReceiveRequestAttributesGetter() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequestAttributesGetter", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsProcessRequestAttributesGetter {
        Delete_SqsProcessRequestAttributesGetter() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsParentContext", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsParentContext {
        Delete_SqsParentContext() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsMessageImpl", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsMessageImpl {
        Delete_SqsMessageImpl() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsImpl", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    @Delete
    static final class Delete_SqsImpl {
        Delete_SqsImpl() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkInstrumenterFactory", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Target_AwsSdkInstrumenterFactory {
        Target_AwsSdkInstrumenterFactory() {
        }

        @Substitute
        Instrumenter<Alias_ResponseSqsProcessRequest, Alias_Response> consumerProcessInstrumenter() {
            return null;
        }

        @Substitute
        Instrumenter<Alias_ResponseSqsReceiveRequest, Alias_Response> consumerReceiveInstrumenter() {
            return null;
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsAccess", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Target_SqsAccess {
        @Delete
        private static boolean enabled;

        Target_SqsAccess() {
        }

        @Substitute
        static boolean afterReceiveMessageExecution(Context.AfterExecution context, ExecutionAttributes executionAttributes, Alias_TracingExecutionInterceptor config, Timer timer) {
            return false;
        }

        @Substitute
        static SdkRequest modifyRequest(SdkRequest request, Context otelContext, boolean useXrayPropagator, TextMapPropagator messagingPropagator) {
            return null;
        }

        @Substitute
        static boolean isSqsProducerRequest(SdkRequest request) {
            return false;
        }

        @Substitute
        static String getQueueUrl(SdkRequest request) {
            return null;
        }

        @Substitute
        static String getMessageAttribute(SdkRequest request, String name) {
            return null;
        }

        @Substitute
        static String getMessageId(SdkResponse response) {
            return null;
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.TracingExecutionInterceptor", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Alias_TracingExecutionInterceptor {
        Alias_TracingExecutionInterceptor() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsReceiveRequest", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Alias_ResponseSqsReceiveRequest {
        Alias_ResponseSqsReceiveRequest() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.SqsProcessRequest", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Alias_ResponseSqsProcessRequest {
        Alias_ResponseSqsProcessRequest() {
        }
    }

    @TargetClass(className="io.opentelemetry.instrumentation.awssdk.v2_2.Response", onlyWith={IsSqsAbsent.class, IsOtelAwsPresent.class, IsOtelNewAwsAbsent.class})
    static final class Alias_Response {
        Alias_Response() {
        }
    }

    static final class IsSnsPresent
    implements BooleanSupplier {
        IsSnsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.SOFTWARE_AMAZON_AWSSDK_SNS_PACKAGE));
        }
    }

    static final class IsSqsPresent
    implements BooleanSupplier {
        IsSqsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.SOFTWARE_AMAZON_AWSSDK_SQS_PACKAGE));
        }
    }

    static final class IsSnsAbsent
    implements BooleanSupplier {
        IsSnsAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.SOFTWARE_AMAZON_AWSSDK_SNS_PACKAGE));
        }
    }

    static final class IsSqsAbsent
    implements BooleanSupplier {
        IsSqsAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.SOFTWARE_AMAZON_AWSSDK_SQS_PACKAGE));
        }
    }

    static final class IsOtelNewAwsAbsent
    implements BooleanSupplier {
        IsOtelNewAwsAbsent() {
        }

        @Override
        public boolean getAsBoolean() {
            return !Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.IO_OPENTELEMETRY_INSTRUMENTATION_AWSSDK_V2_2_INTERNAL_PACKAGE));
        }
    }

    static final class IsOtelAwsPresent
    implements BooleanSupplier {
        IsOtelAwsPresent() {
        }

        @Override
        public boolean getAsBoolean() {
            return Arrays.asList(Package.getPackages()).stream().map(p -> p.getName()).anyMatch(p -> p.equals(OtelOldSubstitutions.IO_OPENTELEMETRY_INSTRUMENTATION_AWSSDK_V2_2_PACKAGE));
        }
    }
}

