/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import zmq.Command;
import zmq.Ctx;
import zmq.Mailbox;
import zmq.SocketBase;
import zmq.ZObject;
import zmq.poll.IPollEvents;
import zmq.poll.Poller;

final class Reaper
extends ZObject
implements IPollEvents,
Closeable {
    private final Mailbox mailbox;
    private final Poller.Handle mailboxHandle;
    private final Poller poller;
    private int socketsReaping = 0;
    private final AtomicBoolean terminating = new AtomicBoolean();
    private final String name;

    Reaper(Ctx ctx, int tid) {
        super(ctx, tid);
        this.name = "reaper-" + tid;
        this.poller = new Poller(ctx, this.name);
        this.mailbox = new Mailbox(ctx, this.name, tid);
        SelectableChannel fd = this.mailbox.getFd();
        this.mailboxHandle = this.poller.addHandle(fd, this);
        this.poller.setPollIn(this.mailboxHandle);
    }

    @Override
    public void close() throws IOException {
        this.poller.destroy();
        this.mailbox.close();
    }

    Mailbox getMailbox() {
        return this.mailbox;
    }

    void start() {
        this.poller.start();
    }

    void stop() {
        if (!this.terminating.get()) {
            this.sendStop();
        }
    }

    @Override
    public void inEvent() {
        Command cmd;
        while ((cmd = this.mailbox.recv(0L)) != null) {
            cmd.process();
        }
    }

    @Override
    public void outEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connectEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void acceptEvent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void timerEvent(int id2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void processStop() {
        this.terminating.set(true);
        if (this.socketsReaping == 0) {
            this.finishTerminating();
        }
    }

    @Override
    protected void processReap(SocketBase socket) {
        ++this.socketsReaping;
        socket.startReaping(this.poller);
    }

    @Override
    protected void processReaped() {
        --this.socketsReaping;
        if (this.socketsReaping == 0 && this.terminating.get()) {
            this.finishTerminating();
        }
    }

    private void finishTerminating() {
        this.sendDone();
        this.poller.removeHandle(this.mailboxHandle);
        this.poller.stop();
    }
}

