/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;

public interface PostgresDataDefinition {
    public static final PostgresDataDefinition EMPTY_MODULE = PostgresDataDefinition.builder().build();

    public static PostgresDataDefinition aggregateModules(PostgresDataDefinition ... modules) {
        return PostgresDataDefinition.builder().modules(modules).build();
    }

    public static PostgresDataDefinition aggregateModules(Collection<PostgresDataDefinition> modules) {
        return PostgresDataDefinition.builder().modules(modules).build();
    }

    public List<PostgresTable> tables();

    public List<PostgresIndex> tableIndexes();

    public static Builder builder() {
        return new Builder();
    }

    public static PostgresDataDefinition table(PostgresTable ... tables) {
        return PostgresDataDefinition.builder().addTable((List<PostgresTable>)ImmutableList.copyOf((Object[])tables)).build();
    }

    public static PostgresDataDefinition tableIndex(PostgresIndex ... tableIndexes) {
        return PostgresDataDefinition.builder().addIndex((List<PostgresIndex>)ImmutableList.copyOf((Object[])tableIndexes)).build();
    }

    public static class Builder {
        private final ImmutableList.Builder<PostgresTable> tables = ImmutableList.builder();
        private final ImmutableList.Builder<PostgresIndex> tableIndexes = ImmutableList.builder();

        public Builder addTable(PostgresTable ... table) {
            this.tables.add((Object[])table);
            return this;
        }

        public Builder addIndex(PostgresIndex ... index) {
            this.tableIndexes.add((Object[])index);
            return this;
        }

        public Builder addTable(List<PostgresTable> tables) {
            this.tables.addAll(tables);
            return this;
        }

        public Builder addIndex(List<PostgresIndex> indexes) {
            this.tableIndexes.addAll(indexes);
            return this;
        }

        public Builder modules(Collection<PostgresDataDefinition> modules) {
            modules.forEach(module -> {
                this.addTable(module.tables());
                this.addIndex(module.tableIndexes());
            });
            return this;
        }

        public Builder modules(PostgresDataDefinition ... modules) {
            return this.modules((Collection<PostgresDataDefinition>)ImmutableList.copyOf((Object[])modules));
        }

        public PostgresDataDefinition build() {
            return new Impl((List<PostgresTable>)this.tables.build(), (List<PostgresIndex>)this.tableIndexes.build());
        }
    }

    public static class Impl
    implements PostgresDataDefinition {
        private final List<PostgresTable> tables;
        private final List<PostgresIndex> tableIndexes;

        private Impl(List<PostgresTable> tables, List<PostgresIndex> tableIndexes) {
            this.tables = tables;
            this.tableIndexes = tableIndexes;
        }

        @Override
        public List<PostgresTable> tables() {
            return this.tables;
        }

        @Override
        public List<PostgresIndex> tableIndexes() {
            return this.tableIndexes;
        }
    }
}

