/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.vault.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.vault.DeletedMessage;
import org.apache.james.vault.search.Criterion;

public class Query {
    public static final Query ALL = new Query((List<Criterion<?>>)ImmutableList.of());
    private static final Predicate<DeletedMessage> MATCH_ALL = any -> true;
    private final List<Criterion<?>> criteria;
    private final Optional<Long> limit;

    public static Query and(List<Criterion<?>> criteria) {
        return new Query(criteria);
    }

    public static Query and(List<Criterion<?>> criteria, Optional<Long> limit) {
        return new Query(criteria, limit.orElse(null));
    }

    public static Query of(Criterion<?> ... criteria) {
        return new Query((List<Criterion<?>>)ImmutableList.copyOf((Object[])criteria));
    }

    public static Query of(long limit, List<Criterion<?>> criteria) {
        return new Query(criteria, limit);
    }

    private Query(List<Criterion<?>> criteria) {
        this.criteria = criteria;
        this.limit = Optional.empty();
    }

    public Query(List<Criterion<?>> criteria, Long limit) {
        Preconditions.checkArgument((limit == null || limit > 0L ? 1 : 0) != 0, (Object)"Limit should be strictly positive");
        this.criteria = criteria;
        this.limit = Optional.ofNullable(limit);
    }

    public Predicate<DeletedMessage> toPredicate() {
        return this.criteria.stream().map(Criterion::toPredicate).reduce(Predicate::and).orElse(MATCH_ALL);
    }

    public List<Criterion<?>> getCriteria() {
        return this.criteria;
    }

    public Optional<Long> getLimit() {
        return this.limit;
    }
}

