/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql.api;

import io.r2dbc.postgresql.message.backend.Field;
import io.r2dbc.postgresql.util.Assert;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class ErrorDetails {
    private final String code;
    private final String columnName;
    private final String constraintName;
    private final String dataTypeName;
    private final String detail;
    private final String file;
    private final String hint;
    private final String internalPosition;
    private final String internalQuery;
    private final String line;
    private final String message;
    private final String position;
    private final String routine;
    private final String schemaName;
    private final String severityLocalized;
    private final String severityNonLocalized;
    private final String tableName;
    private final String where;

    public ErrorDetails(List<Field> fields) {
        this(ErrorDetails.convertToMap(fields));
    }

    private ErrorDetails(Map<Field.FieldType, String> fields) {
        this.code = fields.getOrDefault((Object)Field.FieldType.CODE, "99999");
        this.columnName = fields.get((Object)Field.FieldType.COLUMN_NAME);
        this.constraintName = fields.get((Object)Field.FieldType.CONSTRAINT_NAME);
        this.dataTypeName = fields.get((Object)Field.FieldType.DATA_TYPE_NAME);
        this.detail = fields.get((Object)Field.FieldType.DETAIL);
        this.file = fields.get((Object)Field.FieldType.FILE);
        this.hint = fields.get((Object)Field.FieldType.HINT);
        this.internalPosition = fields.get((Object)Field.FieldType.INTERNAL_POSITION);
        this.internalQuery = fields.get((Object)Field.FieldType.INTERNAL_QUERY);
        this.line = fields.get((Object)Field.FieldType.LINE);
        this.message = fields.get((Object)Field.FieldType.MESSAGE);
        this.position = fields.get((Object)Field.FieldType.POSITION);
        this.routine = fields.get((Object)Field.FieldType.ROUTINE);
        this.schemaName = fields.get((Object)Field.FieldType.SCHEMA_NAME);
        this.severityLocalized = fields.get((Object)Field.FieldType.SEVERITY_LOCALIZED);
        this.severityNonLocalized = fields.get((Object)Field.FieldType.SEVERITY_NON_LOCALIZED);
        this.tableName = fields.get((Object)Field.FieldType.TABLE_NAME);
        this.where = fields.get((Object)Field.FieldType.WHERE);
    }

    public static ErrorDetails fromMessage(String message) {
        return new ErrorDetails(Collections.singletonMap(Field.FieldType.MESSAGE, message));
    }

    public static ErrorDetails fromCodeAndMessage(String code, String message) {
        LinkedHashMap<Field.FieldType, String> details = new LinkedHashMap<Field.FieldType, String>(2);
        details.put(Field.FieldType.CODE, code);
        details.put(Field.FieldType.MESSAGE, message);
        return new ErrorDetails(details);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorDetails that = (ErrorDetails)o;
        return Objects.equals(this.code, that.code) && Objects.equals(this.columnName, that.columnName) && Objects.equals(this.constraintName, that.constraintName) && Objects.equals(this.dataTypeName, that.dataTypeName) && Objects.equals(this.detail, that.detail) && Objects.equals(this.file, that.file) && Objects.equals(this.hint, that.hint) && Objects.equals(this.internalPosition, that.internalPosition) && Objects.equals(this.internalQuery, that.internalQuery) && Objects.equals(this.line, that.line) && Objects.equals(this.message, that.message) && Objects.equals(this.position, that.position) && Objects.equals(this.routine, that.routine) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.severityLocalized, that.severityLocalized) && Objects.equals(this.severityNonLocalized, that.severityNonLocalized) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.where, that.where);
    }

    public String getCode() {
        return this.code;
    }

    public Optional<String> getColumnName() {
        return Optional.ofNullable(this.columnName);
    }

    public Optional<String> getConstraintName() {
        return Optional.ofNullable(this.constraintName);
    }

    public Optional<String> getDataTypeName() {
        return Optional.ofNullable(this.dataTypeName);
    }

    public Optional<String> getDetail() {
        return Optional.ofNullable(this.detail);
    }

    public Optional<String> getFile() {
        return Optional.ofNullable(this.file);
    }

    public Optional<String> getHint() {
        return Optional.ofNullable(this.hint);
    }

    public Optional<String> getInternalPosition() {
        return Optional.ofNullable(this.internalPosition);
    }

    public Optional<String> getInternalQuery() {
        return Optional.ofNullable(this.internalQuery);
    }

    public Optional<String> getLine() {
        return Optional.ofNullable(this.line);
    }

    public String getMessage() {
        return this.message;
    }

    public Optional<String> getPosition() {
        return Optional.ofNullable(this.position);
    }

    public Optional<String> getRoutine() {
        return Optional.ofNullable(this.routine);
    }

    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public String getSeverityLocalized() {
        return this.severityLocalized;
    }

    public String getSeverityNonLocalized() {
        return this.severityNonLocalized;
    }

    public Optional<String> getTableName() {
        return Optional.ofNullable(this.tableName);
    }

    public Optional<String> getWhere() {
        return Optional.ofNullable(this.where);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.columnName, this.constraintName, this.dataTypeName, this.detail, this.file, this.hint, this.internalPosition, this.internalQuery, this.line, this.message, this.position, this.routine, this.schemaName, this.severityLocalized, this.severityNonLocalized, this.tableName, this.where);
    }

    public String toString() {
        return "ErrorDetails{code='" + this.code + '\'' + ", columnName='" + this.columnName + '\'' + ", constraintName='" + this.constraintName + '\'' + ", dataTypeName='" + this.dataTypeName + '\'' + ", detail='" + this.detail + '\'' + ", file='" + this.file + '\'' + ", hint='" + this.hint + '\'' + ", internalPosition='" + this.internalPosition + '\'' + ", internalQuery='" + this.internalQuery + '\'' + ", line='" + this.line + '\'' + ", message='" + this.message + '\'' + ", position='" + this.position + '\'' + ", routine='" + this.routine + '\'' + ", schemaName='" + this.schemaName + '\'' + ", severityLocalized='" + this.severityLocalized + '\'' + ", severityNonLocalized='" + this.severityNonLocalized + '\'' + ", tableName='" + this.tableName + '\'' + ", where='" + this.where + '\'' + "} " + super.toString();
    }

    private static Map<Field.FieldType, String> convertToMap(List<Field> fields) {
        Assert.requireNonNull(fields, "fields must not be null");
        HashMap<Field.FieldType, String> fieldMap = new HashMap<Field.FieldType, String>(fields.size());
        for (Field field : fields) {
            fieldMap.put(field.getType(), field.getValue());
        }
        return fieldMap;
    }
}

