/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ShutdownTask
extends Task {
    @NotNull
    static final String SHUTDOWN_TASK_CLASS = "com.unboundid.directory.server.tasks.ShutdownTask";
    @NotNull
    private static final String ATTR_SHUTDOWN_MESSAGE = "ds-task-shutdown-message";
    @NotNull
    private static final String ATTR_RESTART_SERVER = "ds-task-restart-server";
    @NotNull
    private static final String OC_SHUTDOWN_TASK = "ds-task-shutdown";
    @NotNull
    private static final TaskProperty PROPERTY_SHUTDOWN_MESSAGE = new TaskProperty("ds-task-shutdown-message", TaskMessages.INFO_DISPLAY_NAME_SHUTDOWN_MESSAGE.get(), TaskMessages.INFO_DESCRIPTION_SHUTDOWN_MESSAGE.get(), String.class, false, false, false);
    @NotNull
    private static final TaskProperty PROPERTY_RESTART_SERVER = new TaskProperty("ds-task-restart-server", TaskMessages.INFO_DISPLAY_NAME_RESTART_SERVER.get(), TaskMessages.INFO_DESCRIPTION_RESTART_SERVER.get(), Boolean.class, false, false, false);
    private static final long serialVersionUID = -5332685779844073667L;
    private final boolean restartServer;
    @Nullable
    private final String shutdownMessage;

    public ShutdownTask() {
        this.shutdownMessage = null;
        this.restartServer = false;
    }

    public ShutdownTask(@Nullable String taskID, @Nullable String shutdownMessage, boolean restartServer) {
        this(taskID, shutdownMessage, restartServer, null, null, null, null, null);
    }

    public ShutdownTask(@Nullable String taskID, @Nullable String shutdownMessage, boolean restartServer, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnError) {
        this(taskID, shutdownMessage, restartServer, scheduledStartTime, dependencyIDs, failedDependencyAction, null, notifyOnCompletion, null, notifyOnError, null, null, null);
    }

    public ShutdownTask(@Nullable String taskID, @Nullable String shutdownMessage, boolean restartServer, @Nullable Date scheduledStartTime, @Nullable List<String> dependencyIDs, @Nullable FailedDependencyAction failedDependencyAction, @Nullable List<String> notifyOnStart, @Nullable List<String> notifyOnCompletion, @Nullable List<String> notifyOnSuccess, @Nullable List<String> notifyOnError, @Nullable Boolean alertOnStart, @Nullable Boolean alertOnSuccess, @Nullable Boolean alertOnError) {
        super(taskID, SHUTDOWN_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.shutdownMessage = shutdownMessage;
        this.restartServer = restartServer;
    }

    public ShutdownTask(@NotNull Entry entry) throws TaskException {
        super(entry);
        this.shutdownMessage = entry.getAttributeValue(ATTR_SHUTDOWN_MESSAGE);
        this.restartServer = ShutdownTask.parseBooleanValue(entry, ATTR_RESTART_SERVER, false);
    }

    public ShutdownTask(@NotNull Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(SHUTDOWN_TASK_CLASS, properties);
        boolean r = false;
        String m = null;
        for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = p.getAttributeName();
            List<Object> values = entry.getValue();
            if (attrName.equalsIgnoreCase(ATTR_SHUTDOWN_MESSAGE)) {
                m = ShutdownTask.parseString(p, values, m);
                continue;
            }
            if (!attrName.equalsIgnoreCase(ATTR_RESTART_SERVER)) continue;
            r = ShutdownTask.parseBoolean(p, values, r);
        }
        this.shutdownMessage = m;
        this.restartServer = r;
    }

    @Override
    @NotNull
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_SHUTDOWN.get();
    }

    @Override
    @NotNull
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_SHUTDOWN.get();
    }

    @Nullable
    public String getShutdownMessage() {
        return this.shutdownMessage;
    }

    public boolean restartServer() {
        return this.restartServer;
    }

    @Override
    @NotNull
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_SHUTDOWN_TASK);
    }

    @Override
    @NotNull
    protected List<Attribute> getAdditionalAttributes() {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>(2);
        if (this.shutdownMessage != null) {
            attrs.add(new Attribute(ATTR_SHUTDOWN_MESSAGE, this.shutdownMessage));
        }
        attrs.add(new Attribute(ATTR_RESTART_SERVER, String.valueOf(this.restartServer)));
        return attrs;
    }

    @Override
    @NotNull
    public List<TaskProperty> getTaskSpecificProperties() {
        List<TaskProperty> propList = Arrays.asList(PROPERTY_SHUTDOWN_MESSAGE, PROPERTY_RESTART_SERVER);
        return Collections.unmodifiableList(propList);
    }

    @Override
    @NotNull
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap<TaskProperty, List<Object>> props = new LinkedHashMap<TaskProperty, List<Object>>(StaticUtils.computeMapCapacity(10));
        if (this.shutdownMessage == null) {
            props.put(PROPERTY_SHUTDOWN_MESSAGE, Collections.emptyList());
        } else {
            props.put(PROPERTY_SHUTDOWN_MESSAGE, Collections.singletonList(this.shutdownMessage));
        }
        props.put(PROPERTY_RESTART_SERVER, Collections.singletonList(this.restartServer));
        props.putAll(super.getTaskPropertyValues());
        return Collections.unmodifiableMap(props);
    }
}

