/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.Capability;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.UnselectRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import reactor.core.publisher.Mono;

public class UnselectProcessor
extends AbstractMailboxProcessor<UnselectRequest>
implements CapabilityImplementingProcessor {
    private static final List<Capability> UNSELECT = ImmutableList.of((Object)ImapConstants.SUPPORTS_UNSELECT);

    @Inject
    public UnselectProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory) {
        super(UnselectRequest.class, mailboxManager, factory, metricFactory);
    }

    @Override
    protected Mono<Void> processRequestReactive(UnselectRequest request, ImapSession session, ImapProcessor.Responder responder) {
        if (session.getSelected() != null) {
            return session.deselect().then(Mono.fromRunnable(() -> this.okComplete(request, responder)));
        }
        this.taggedBad(request, responder, HumanReadableText.UNSELECT);
        return Mono.empty();
    }

    @Override
    public List<Capability> getImplementedCapabilities(ImapSession session) {
        return UNSELECT;
    }

    @Override
    protected MDCBuilder mdc(UnselectRequest request) {
        return MDCBuilder.ofValue((String)"action", (String)"UNSELECT");
    }
}

