/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.github.fge.lambdas.Throwing;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.SerializableQuota;
import org.apache.james.mailbox.model.SerializableQuotaLimitValue;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.util.MDCBuilder;

public class QuotaManagement
implements QuotaManagementMBean {
    private final QuotaManager quotaManager;
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public QuotaManagement(QuotaManager quotaManager, MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.quotaManager = quotaManager;
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        String string;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getQuotaRoot").build();
            try {
                string = this.quotaRootResolver.getQuotaRoot(new MailboxPath(namespace, Username.of((String)user), name)).getValue();
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return string;
    }

    @Override
    public SerializableQuotaLimitValue<QuotaCountLimit> getMaxMessageCount(String quotaRoot) throws MailboxException {
        SerializableQuotaLimitValue serializableQuotaLimitValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getMaxMessageCount").build();
            try {
                serializableQuotaLimitValue = SerializableQuotaLimitValue.valueOf((Optional)this.maxQuotaManager.getMaxMessage(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaLimitValue;
    }

    @Override
    public SerializableQuotaLimitValue<QuotaSizeLimit> getMaxStorage(String quotaRoot) throws MailboxException {
        SerializableQuotaLimitValue serializableQuotaLimitValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getMaxStorage").build();
            try {
                serializableQuotaLimitValue = SerializableQuotaLimitValue.valueOf((Optional)this.maxQuotaManager.getMaxStorage(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaLimitValue;
    }

    @Override
    public SerializableQuotaLimitValue<QuotaCountLimit> getGlobalMaxMessageCount() throws MailboxException {
        SerializableQuotaLimitValue serializableQuotaLimitValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getGlobalMaxMessageCount").build();
            try {
                serializableQuotaLimitValue = SerializableQuotaLimitValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxMessage());
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaLimitValue;
    }

    @Override
    public SerializableQuotaLimitValue<QuotaSizeLimit> getGlobalMaxStorage() throws MailboxException {
        SerializableQuotaLimitValue serializableQuotaLimitValue;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getGlobalMaxStorage").build();
            try {
                serializableQuotaLimitValue = SerializableQuotaLimitValue.valueOf((Optional)this.maxQuotaManager.getGlobalMaxStorage());
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuotaLimitValue;
    }

    @Override
    public void setMaxMessageCount(String quotaRoot, SerializableQuotaLimitValue<QuotaCountLimit> maxMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "setMaxMessageCount").build();){
            maxMessageCount.toValue(QuotaCountLimit::count, (QuotaLimitValue)QuotaCountLimit.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxMessage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setMaxStorage(String quotaRoot, SerializableQuotaLimitValue<QuotaSizeLimit> maxSize) {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "setMaxStorage").build();){
            maxSize.toValue(QuotaSizeLimit::size, (QuotaLimitValue)QuotaSizeLimit.unlimited()).ifPresent(Throwing.consumer(value -> this.maxQuotaManager.setMaxStorage(this.quotaRootResolver.fromString(quotaRoot), value)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxMessageCount(SerializableQuotaLimitValue<QuotaCountLimit> maxGlobalMessageCount) {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "setGlobalMaxMessageCount").build();){
            maxGlobalMessageCount.toValue(QuotaCountLimit::count, (QuotaLimitValue)QuotaCountLimit.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxMessage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setGlobalMaxStorage(SerializableQuotaLimitValue<QuotaSizeLimit> maxGlobalSize) {
        try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "setGlobalMaxStorage").build();){
            maxGlobalSize.toValue(QuotaSizeLimit::size, (QuotaLimitValue)QuotaSizeLimit.unlimited()).ifPresent(Throwing.consumer(arg_0 -> ((MaxQuotaManager)this.maxQuotaManager).setGlobalMaxStorage(arg_0)).sneakyThrow());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SerializableQuota<QuotaCountLimit, QuotaCountUsage> getMessageCountQuota(String quotaRoot) throws MailboxException {
        SerializableQuota serializableQuota;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getMessageCountQuota").build();
            try {
                serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getMessageQuota(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuota;
    }

    @Override
    public SerializableQuota<QuotaSizeLimit, QuotaSizeUsage> getStorageQuota(String quotaRoot) throws MailboxException {
        SerializableQuota serializableQuota;
        block8: {
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "getStorageQuota").build();
            try {
                serializableQuota = SerializableQuota.newInstance((Quota)this.quotaManager.getStorageQuota(this.quotaRootResolver.fromString(quotaRoot)));
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        try {
                            closeable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            closeable.close();
        }
        return serializableQuota;
    }
}

