/*
 * Decompiled with CFR 0.152.
 */
package com.github.f4b6a3.uuid.codec.base.function;

import com.github.f4b6a3.uuid.codec.base.BaseN;
import com.github.f4b6a3.uuid.exception.InvalidUuidException;
import com.github.f4b6a3.uuid.util.immutable.ByteArray;
import java.util.UUID;
import java.util.function.Function;

public abstract class BaseNDecoder
implements Function<String, UUID> {
    protected final BaseN base;
    protected final ByteArray map;

    public BaseNDecoder(BaseN base) {
        this.base = base;
        this.map = base.getMap();
    }

    protected long get(String string, int i) {
        char chr = string.charAt(i);
        if (chr > '\u00ff') {
            throw InvalidUuidException.newInstance(string);
        }
        byte value = this.map.get(chr);
        if (value < 0) {
            throw InvalidUuidException.newInstance(string);
        }
        return (long)value & 0xFFL;
    }
}

