/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system;

import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.system.StreamRDFLimited;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.riot.RDFParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;

public class GraphLoadUtils {
    public static Graph readGraph(String uri, int limit) {
        Graph g = GraphMemFactory.createDefaultGraphSameTerm();
        GraphLoadUtils.readUtil(g, uri, limit);
        return g;
    }

    public static void loadGraph(Graph g, String uri, int limit) {
        GraphLoadUtils.readUtil(g, uri, limit);
    }

    public static DatasetGraph readDataset(String uri, int limit) {
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        GraphLoadUtils.readUtil(dsg, uri, limit);
        return dsg;
    }

    public static void loadDataset(DatasetGraph dsg, String uri, int limit) {
        GraphLoadUtils.readUtil(dsg, uri, limit);
    }

    private static void readUtil(Graph graph, String uri, int limit) {
        StreamRDF sink = StreamRDFLib.graph(graph);
        sink = new StreamRDFLimited(sink, limit);
        RDFParser.source(uri).streamManager(Fuseki.webStreamManager).parse(sink);
    }

    private static void readUtil(DatasetGraph dsg, String uri, int limit) {
        StreamRDF sink = StreamRDFLib.dataset(dsg);
        sink = new StreamRDFLimited(sink, limit);
        RDFParser.source(uri).streamManager(Fuseki.webStreamManager).parse(sink);
    }
}

