/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash.format;

import java.util.Objects;
import org.apache.shiro.crypto.hash.AbstractCryptHash;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashProvider;
import org.apache.shiro.crypto.hash.HashSpi;
import org.apache.shiro.crypto.hash.format.ModularCryptFormat;
import org.apache.shiro.crypto.hash.format.ParsableHashFormat;
import org.apache.shiro.crypto.hash.format.Shiro1CryptFormat;

public class Shiro2CryptFormat
implements ModularCryptFormat,
ParsableHashFormat {
    public static final String ID = "shiro2";
    public static final String MCF_PREFIX = "$shiro2$";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String format(Hash hash) {
        Objects.requireNonNull(hash, "hash in Shiro2CryptFormat.format(Hash hash)");
        if (!(hash instanceof AbstractCryptHash)) {
            throw new UnsupportedOperationException("Shiro2CryptFormat can only format classes extending AbstractCryptHash.");
        }
        AbstractCryptHash cryptHash = (AbstractCryptHash)hash;
        return "$shiro2" + cryptHash.formatToCryptString();
    }

    @Override
    public Hash parse(String formatted) {
        Objects.requireNonNull(formatted, "formatted in Shiro2CryptFormat.parse(String formatted)");
        if (formatted.startsWith("$shiro1$")) {
            return new Shiro1CryptFormat().parse(formatted);
        }
        if (!formatted.startsWith(MCF_PREFIX)) {
            String msg = "The argument is not a valid 'shiro2' formatted hash.";
            throw new IllegalArgumentException("The argument is not a valid 'shiro2' formatted hash.");
        }
        String suffix = formatted.substring(MCF_PREFIX.length());
        String[] parts = suffix.split("\\$");
        String algorithmName = parts[0];
        HashSpi kdfHash = HashProvider.getByAlgorithmName(algorithmName).orElseThrow(() -> new UnsupportedOperationException("Algorithm " + algorithmName + " is not implemented."));
        return kdfHash.fromString("$" + suffix);
    }
}

