/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.util.ArraysExt;

final class StoredTree
implements Serializable {
    private static final long serialVersionUID = 8436779786449395346L;
    private final Node root;
    private final short[] offsets;

    StoredTree(Element tree, Map<Object, Object> sharedValues) {
        Deflater deflater = new Deflater(sharedValues);
        this.root = (Node)deflater.unique(new Node(deflater, tree));
        this.offsets = deflater.offsets();
    }

    StoredTree(List<Element> trees, Map<Object, Object> sharedValues) {
        Deflater deflater = new Deflater(sharedValues);
        this.root = new Node(deflater, trees);
        this.offsets = deflater.offsets();
    }

    final void toElements(AbstractParser parser, Collection<? super Element> addTo, int isFragment) {
        this.root.toElements(new Inflater(parser, this.offsets, isFragment), addTo);
    }

    final void peekIdentifiers(Object[] fullId) {
        Node id = this.root.peekLastElement(MathTransformParser.ID_KEYWORDS);
        if (id != null) {
            id.peekValues(fullId, 0);
            if (fullId.length >= 4 && (id = id.peekLastElement("Citation")) != null) {
                id.peekValues(fullId, 3);
            }
        }
    }

    final void forEachValue(Consumer<Object> addTo) {
        this.root.forEachValue(addTo);
    }

    final String keyword() {
        return this.root.keyword;
    }

    public String toString() {
        return this.root.toString();
    }

    private static final class Deflater {
        private Map<Object, Object> sharedValues;
        private short[] offsets;
        private int count;

        Deflater(Map<Object, Object> sharedValues) {
            this.sharedValues = sharedValues;
            this.offsets = new short[24];
        }

        final Object unique(Object value) {
            Object existing = this.sharedValues.putIfAbsent(value, value);
            return existing != null ? existing : value;
        }

        final void addOffset(Element element) {
            if (this.count >= this.offsets.length) {
                this.offsets = Arrays.copyOf(this.offsets, this.count * 2);
            }
            int offset = Math.min(Short.MAX_VALUE, Math.max(0, element.offset));
            if (element.isFragment) {
                offset ^= 0xFFFFFFFF;
            }
            this.offsets[this.count++] = (short)offset;
        }

        final short[] offsets() {
            this.offsets = ArraysExt.resize(this.offsets, this.count);
            short[] other = (short[])this.sharedValues.putIfAbsent(this, this.offsets);
            this.sharedValues = null;
            if (other != null) {
                this.offsets = other;
            }
            return this.offsets;
        }

        public boolean equals(Object other) {
            assert (this.offsets.length == this.count);
            return other instanceof Deflater && Arrays.equals(this.offsets, ((Deflater)other).offsets);
        }

        public int hashCode() {
            assert (this.offsets.length == this.count);
            return Arrays.hashCode(this.offsets);
        }
    }

    private static final class Node
    implements Serializable {
        private static final long serialVersionUID = 1463070931527783896L;
        final String keyword;
        private final Object[] children;

        Node(Deflater deflater, List<Element> elements) {
            this.keyword = null;
            this.children = new Node[elements.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = deflater.unique(new Node(deflater, elements.get(i)));
            }
        }

        Node(Deflater deflater, Element element) {
            this.keyword = (String)deflater.unique(element.keyword);
            this.children = element.getChildren();
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    Object child = this.children[i];
                    if (child instanceof Element) {
                        child = new Node(deflater, (Element)child);
                    }
                    this.children[i] = deflater.unique(child);
                }
            }
            deflater.addOffset(element);
        }

        final void toElements(Inflater inflater, Collection<? super Element> addTo) {
            if (this.keyword != null) {
                addTo.add(this.toElement(inflater));
            } else {
                for (Node child : (Node[])this.children) {
                    addTo.add(child.toElement(inflater));
                }
            }
        }

        private Element toElement(Inflater inflater) {
            LinkedList<Object> list;
            if (this.children == null) {
                list = null;
            } else {
                list = new LinkedList<Object>();
                for (Object child : this.children) {
                    if (child instanceof Node) {
                        child = ((Node)child).toElement(inflater);
                    }
                    list.add(child);
                }
            }
            return new Element(this.keyword, list, inflater.nextOffset(), inflater.errorLocale);
        }

        final Node peekLastElement(String ... keys) {
            if (this.children != null) {
                int i = this.children.length;
                while (--i >= 0) {
                    Object object = this.children[i];
                    if (!(object instanceof Node)) continue;
                    Node node = (Node)object;
                    if (node.children == null) continue;
                    for (String key : keys) {
                        if (!node.keyword.equalsIgnoreCase(key)) continue;
                        return node;
                    }
                }
            }
            return null;
        }

        final void peekValues(Object[] addTo, int index) {
            for (Object object : this.children) {
                if (object instanceof Node) continue;
                addTo[index] = object;
                if (++index >= addTo.length) break;
            }
        }

        final void forEachValue(Consumer<Object> addTo) {
            if (this.keyword != null) {
                addTo.accept(this.keyword);
            }
            if (this.children != null) {
                for (Object child : this.children) {
                    addTo.accept(child);
                    if (!(child instanceof Node)) continue;
                    ((Node)child).forEachValue(addTo);
                }
            }
        }

        public String toString() {
            return this.children != null && this.children.length != 0 ? String.valueOf(this.children[0]) : this.keyword;
        }

        public int hashCode() {
            int hash = this.keyword.hashCode();
            if (this.children != null) {
                for (Object value : this.children) {
                    hash = 31 * hash + (value instanceof Node ? System.identityHashCode(value) : value.hashCode());
                }
            }
            return hash;
        }

        public boolean equals(Object other) {
            if (other instanceof Node) {
                Node that = (Node)other;
                if (this.keyword.equals(that.keyword)) {
                    if (this.children == that.children) {
                        return true;
                    }
                    if (this.children != null && that.children != null && this.children.length == that.children.length) {
                        for (int i = 0; i < this.children.length; ++i) {
                            Object value = this.children[i];
                            Object otherValue = that.children[i];
                            if (!(value instanceof Node) ? value.equals(otherValue) : value == otherValue) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class Inflater {
        private final int isFragment;
        private final short[] offsets;
        private int index;
        final Locale errorLocale;

        Inflater(AbstractParser parser, short[] offsets, int isFragment) {
            this.errorLocale = parser.errorLocale;
            this.isFragment = isFragment;
            this.offsets = offsets;
        }

        final int nextOffset() {
            return this.isFragment != 0 ? this.isFragment : this.offsets[this.index++];
        }
    }
}

