/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.exceptions.SupplierWithException;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.http.HttpClient;
import aQute.bnd.memoize.CloseableMemoize;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryDonePlugin;
import aQute.bnd.service.url.URLConnectionHandler;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.cryptography.SHA1;
import java.io.File;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.URL;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsContainer
extends AbstractSet<Object>
implements Set<Object>,
Registry {
    private static final Logger logger = LoggerFactory.getLogger(PluginsContainer.class);
    private static final MethodType defaultConstructor = MethodType.methodType(Void.TYPE);
    private final Set<Object> plugins = new CopyOnWriteArraySet<Object>();
    private final Set<String> missingCommand = new HashSet<String>();
    private final Set<AutoCloseable> closeablePlugins = new HashSet<AutoCloseable>();

    protected PluginsContainer() {
    }

    protected void init(Processor processor) {
        String spe = processor.getProperty("-plugin");
        if ("none".equals(spe)) {
            return;
        }
        this.add(processor);
        processor.setTypeSpecificPlugins(this);
        if (processor.getParent() != null) {
            this.addAll(processor.getParent().getPlugins());
        }
        spe = processor.mergeLocalProperties("-plugin");
        String pluginPath = processor.mergeProperties("-pluginpath");
        this.loadPlugins(processor, spe, pluginPath);
    }

    protected void postInit(Processor processor) {
        processor.addExtensions(this);
        for (RegistryDonePlugin rdp : this.getPlugins(RegistryDonePlugin.class)) {
            try {
                rdp.done();
            }
            catch (Exception e) {
                processor.exception(e, "Calling done on %s, gives an exception", rdp);
            }
        }
    }

    protected Set<Object> plugins() {
        return this.plugins;
    }

    protected <T> Stream<T> stream(Class<T> type) {
        Stream<Object> stream = this.stream().filter(type::isInstance);
        return stream;
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        Optional<Object> first = this.stream(type).findFirst();
        return first.orElse(null);
    }

    @Override
    public <T> List<T> getPlugins(Class<T> type) {
        List list = this.stream(type).collect(Collectors.toList());
        return list;
    }

    @Override
    public boolean add(Object plugin) {
        return this.plugins().add(plugin);
    }

    @Override
    public boolean addAll(Collection<? extends Object> collection) {
        return this.plugins().addAll(collection);
    }

    @Override
    public boolean remove(Object plugin) {
        return this.plugins().remove(plugin);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.plugins().iterator();
    }

    @Override
    public Spliterator<Object> spliterator() {
        return this.plugins().spliterator();
    }

    @Override
    public Stream<Object> stream() {
        return this.plugins().stream();
    }

    @Override
    public int size() {
        return this.plugins().size();
    }

    @Override
    public String toString() {
        return this.plugins().toString();
    }

    protected void loadPlugins(Processor processor, String pluginString, String pluginPathString) {
        Attrs attrs;
        String className;
        Parameters pluginParameters = new Parameters(pluginString, processor, true);
        Processor.CL loader = processor.getLoader();
        pluginParameters.stream().flatMapValue(v -> Strings.splitAsStream(v.get("path:"))).forEachOrdered((key, path) -> {
            try {
                File f = processor.getFile((String)path).getAbsoluteFile();
                loader.add(f);
            }
            catch (Exception e) {
                processor.exception(e, "Problem adding path %s to loader for plugin %s", path, Processor.removeDuplicateMarker(key));
            }
        });
        HashSet<String> loaded = new HashSet<String>();
        for (Map.Entry<String, Attrs> entry : pluginParameters.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Trying pre-plugin {}", (Object)className);
            Object plugin = this.loadPlugin(processor, processor.getClass().getClassLoader(), attrs, className, true);
            if (plugin == null) continue;
            loaded.add(entry.getKey());
        }
        pluginParameters.keySet().removeAll(loaded);
        this.loadPluginPath(processor, pluginPathString, loader);
        for (Map.Entry<String, Attrs> entry : pluginParameters.entrySet()) {
            className = Processor.removeDuplicateMarker(entry.getKey());
            attrs = entry.getValue();
            logger.debug("Loading secondary plugin {}", (Object)className);
            String commands = attrs.get("command:");
            Object plugin = this.loadPlugin(processor, loader, attrs, className, commands != null);
            if (plugin != null) continue;
            Strings.splitAsStream(commands).forEach(this.missingCommand::add);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPluginPath(Processor processor, String pluginPath, Processor.CL loader) {
        CloseableMemoize<HttpClient> client = CloseableMemoize.closeableSupplier(SupplierWithException.asSupplier(() -> {
            HttpClient c = new HttpClient();
            c.setRegistry(this);
            c.readSettings(processor);
            this.stream(URLConnectionHandler.class).forEach(c::addURLConnectionHandler);
            return c;
        }));
        Parameters pluginPathParameters = new Parameters(pluginPath, processor);
        try {
            for (Map.Entry<String, Attrs> entry : pluginPathParameters.entrySet()) {
                File f;
                block26: {
                    f = processor.getFile(entry.getKey()).getAbsoluteFile();
                    if (!f.isFile()) {
                        String url = entry.getValue().get("url");
                        if (url != null) {
                            try {
                                logger.debug("downloading {} to {}", (Object)url, (Object)f.getAbsoluteFile());
                                URL u = new URL(url);
                                IO.mkdirs(f.getParentFile());
                                try (Resource resource = Resource.fromURL(u, (HttpClient)client.get());){
                                    try (OutputStream out = IO.outputStream(f);){
                                        resource.write(out);
                                    }
                                    long lastModified = resource.lastModified();
                                    if (lastModified > 0L) {
                                        f.setLastModified(lastModified);
                                    }
                                }
                                String digest = entry.getValue().get("sha1");
                                if (digest == null) break block26;
                                if (Hex.isHex(digest.trim())) {
                                    byte[] filesha1;
                                    byte[] sha1 = Hex.toByteArray(digest);
                                    if (!Arrays.equals(sha1, filesha1 = SHA1.digest(f).digest())) {
                                        processor.error("Plugin path: %s, specified url %s and a sha1 but the file does not match the sha", entry.getKey(), url);
                                    }
                                } else {
                                    processor.error("Plugin path: %s, specified url %s and a sha1 '%s' but this is not a hexadecimal", entry.getKey(), url, digest);
                                }
                                break block26;
                            }
                            catch (Exception e) {
                                processor.exception(e, "Failed to download plugin %s from %s", entry.getKey(), url);
                                continue;
                            }
                        }
                        processor.error("No such file %s from %s and no 'url' attribute on the path so it can be downloaded", entry.getKey(), processor);
                        continue;
                    }
                }
                logger.debug("Adding {} to loader for plugins", (Object)f);
                loader.add(f);
            }
        }
        finally {
            IO.close(client);
        }
    }

    private Object loadPlugin(Processor processor, ClassLoader loader, Attrs attrs, String className, boolean ignoreError) {
        try {
            Class<?> c = loader.loadClass(className);
            Object plugin = MethodHandles.publicLookup().findConstructor(c, defaultConstructor).invoke();
            processor.customize(plugin, attrs, this);
            this.add(plugin);
            if (plugin instanceof AutoCloseable) {
                this.closeablePlugins.add((AutoCloseable)plugin);
            }
            return plugin;
        }
        catch (NoClassDefFoundError e) {
            if (!ignoreError) {
                processor.exception(e, "Failed to load plugin %s;%s", className, attrs);
            }
        }
        catch (ClassNotFoundException e) {
            if (!ignoreError) {
                processor.exception(e, "Failed to load plugin %s;%s", className, attrs);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            processor.exception(e, "Unexpected error loading plugin %s-%s", className, attrs);
        }
        return null;
    }

    boolean isMissingPlugin(String name) {
        return this.missingCommand.contains(name);
    }

    protected void close() {
        this.closeablePlugins.forEach(IO::close);
        this.closeablePlugins.clear();
        this.plugins.clear();
        this.missingCommand.clear();
    }
}

