/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.util.Set;
import javax.jms.IllegalStateException;
import javax.jms.IllegalStateRuntimeException;
import javax.jms.InvalidClientIDException;
import javax.jms.InvalidClientIDRuntimeException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidDestinationRuntimeException;
import javax.jms.InvalidSelectorException;
import javax.jms.InvalidSelectorRuntimeException;
import javax.jms.JMSException;
import javax.jms.JMSRuntimeException;
import javax.jms.JMSSecurityException;
import javax.jms.JMSSecurityRuntimeException;
import javax.jms.MessageFormatException;
import javax.jms.MessageFormatRuntimeException;
import javax.jms.MessageNotWriteableException;
import javax.jms.MessageNotWriteableRuntimeException;
import javax.jms.ResourceAllocationException;
import javax.jms.ResourceAllocationRuntimeException;
import javax.jms.TransactionInProgressException;
import javax.jms.TransactionInProgressRuntimeException;
import javax.jms.TransactionRolledBackException;
import javax.jms.TransactionRolledBackRuntimeException;

final class Utils {
    private Utils() {
    }

    public static JMSException newJMSException(Throwable t) {
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        JMSException se = new JMSException(t.getMessage());
        return (JMSException)se.initCause(t);
    }

    public static JMSRuntimeException convertToRuntimeException(JMSException e) {
        if (e instanceof IllegalStateException) {
            return new IllegalStateRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidClientIDException) {
            return new InvalidClientIDRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidDestinationException) {
            return new InvalidDestinationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof InvalidSelectorException) {
            return new InvalidSelectorRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof JMSSecurityException) {
            return new JMSSecurityRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageFormatException) {
            return new MessageFormatRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof MessageNotWriteableException) {
            return new MessageNotWriteableRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof ResourceAllocationException) {
            return new ResourceAllocationRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionInProgressException) {
            return new TransactionInProgressRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        if (e instanceof TransactionRolledBackException) {
            return new TransactionRolledBackRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        return new JMSRuntimeException(e.getMessage(), e.getErrorCode(), (Throwable)e);
    }

    public static <S extends AutoCloseable> void doClose(Set<S> objects) {
        Utils.doClose(objects, AutoCloseable::close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> void doClose(Set<S> objects, ConsumerWithException<Exception, S> closer) {
        Set<S> set = objects;
        synchronized (set) {
            Utils.forEachQuietly(objects, closer);
            objects.clear();
        }
    }

    public static <E extends Throwable, T> void forEach(Iterable<T> iterable, ConsumerWithException<E, T> consumer) throws E {
        for (T t : iterable) {
            consumer.accept(t);
        }
    }

    public static <E extends Throwable, T> void forEachQuietly(Iterable<T> iterable, ConsumerWithException<E, T> consumer) {
        for (T t : iterable) {
            try {
                consumer.accept(t);
            }
            catch (Throwable throwable) {}
        }
    }

    public static <T> T unsupported(String method) {
        throw new JMSRuntimeException("Illegal call to " + method + " on a managed connection");
    }

    static void debug(String msg) {
    }

    static void debug(String msg, Throwable t) {
    }

    static void trace(String msg) {
    }

    static void trace(String msg, Throwable t) {
    }

    public static interface ConsumerWithException<E extends Throwable, T> {
        public void accept(T var1) throws E;
    }

    public static interface ProviderWithException<E extends Throwable, R> {
        public R call() throws E;
    }

    public static interface RunnableWithException<E extends Throwable> {
        public void run() throws E;
    }
}

