/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.core.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;

public class CircularBuffer<T> {
    private T[] elements;
    private transient int start;
    private transient int end;
    private transient boolean full;
    private final int maxElements;
    private Class<?> type;

    public CircularBuffer(int size, Class<?> type) {
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.type = type;
        this.maxElements = size;
        this.clear();
    }

    private int size() {
        if (this.end == this.start) {
            return this.full ? this.maxElements : 0;
        }
        if (this.end < this.start) {
            return this.maxElements - this.start + this.end;
        }
        return this.end - this.start;
    }

    public synchronized void clear() {
        this.start = 0;
        this.end = 0;
        this.full = false;
        this.elements = (Object[])Array.newInstance(this.type, this.maxElements);
    }

    public synchronized void add(T element) {
        if (null == element) {
            throw new NullPointerException("Attempted to add null object to buffer");
        }
        if (this.full) {
            this.increaseStart();
        }
        this.elements[this.end] = element;
        this.increaseEnd();
    }

    private void increaseStart() {
        ++this.start;
        if (this.start >= this.maxElements) {
            this.start = 0;
        }
    }

    private void increaseEnd() {
        ++this.end;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
    }

    public synchronized Iterable<T> getElements() {
        return this.getElements(this.size());
    }

    public synchronized Iterable<T> getElements(int nb) {
        int s = this.size();
        nb = Math.min(Math.max(0, nb), s);
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < nb; ++i) {
            result.add(this.elements[(i + s - nb + this.start) % this.maxElements]);
        }
        return result;
    }
}

