/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.filter;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;

public class LessEqNode<T>
extends SimpleNode<T> {
    public LessEqNode(AttributeType attributeType, Value value) throws LdapSchemaException {
        super(attributeType, value, AssertionType.LESSEQ);
        if (attributeType != null && attributeType.getOrdering() == null) {
            throw new LdapSchemaException(I18n.err((I18n)I18n.ERR_13301_NO_ORDERING_MR_FOR_AT, (Object[])new Object[]{attributeType.getName()}));
        }
    }

    public LessEqNode(String attribute, byte[] value) throws LdapSchemaException {
        super(attribute, value, AssertionType.LESSEQ);
        if (this.attributeType != null && this.attributeType.getOrdering() == null) {
            throw new LdapSchemaException(I18n.err((I18n)I18n.ERR_13301_NO_ORDERING_MR_FOR_AT, (Object[])new Object[]{this.attributeType.getName()}));
        }
    }

    public LessEqNode(String attribute, String value) throws LdapSchemaException {
        super(attribute, value, AssertionType.LESSEQ);
        if (this.attributeType != null && this.attributeType.getOrdering() == null) {
            throw new LdapSchemaException(I18n.err((I18n)I18n.ERR_13301_NO_ORDERING_MR_FOR_AT, (Object[])new Object[]{this.attributeType.getName()}));
        }
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        if (this.attributeType != null) {
            buf.append(this.attributeType.getName());
        } else {
            buf.append(this.attribute);
        }
        buf.append("<=");
        String escapedValue = this.getEscapedValue();
        if (escapedValue != null) {
            buf.append(escapedValue);
        }
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

