/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.descriptor;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptorExporter;
import org.apache.knox.gateway.descriptor.GatewayDescriptorImporter;
import org.apache.knox.gateway.descriptor.impl.GatewayDescriptorImpl;
import org.apache.knox.gateway.descriptor.xml.XmlGatewayDescriptorExporter;
import org.apache.knox.gateway.descriptor.xml.XmlGatewayDescriptorImporter;

public abstract class GatewayDescriptorFactory {
    private static Map<String, GatewayDescriptorImporter> IMPORTERS = GatewayDescriptorFactory.loadImporters();
    private static Map<String, GatewayDescriptorExporter> EXPORTERS = GatewayDescriptorFactory.loadExporters();

    public static GatewayDescriptor create() {
        return new GatewayDescriptorImpl();
    }

    public static GatewayDescriptor load(String format, Reader reader) throws IOException {
        GatewayDescriptorImporter importer = IMPORTERS.get(format);
        if (importer == null) {
            throw new IllegalArgumentException("No importer for descriptor format " + format);
        }
        return importer.load(reader);
    }

    public static void store(GatewayDescriptor descriptor, String format, Writer writer) throws IOException {
        GatewayDescriptorExporter exporter = EXPORTERS.get(format);
        if (exporter == null) {
            throw new IllegalArgumentException("No exporter for descriptor format " + format);
        }
        exporter.store(descriptor, writer);
    }

    private static Map<String, GatewayDescriptorImporter> loadImporters() {
        ConcurrentHashMap<String, GatewayDescriptorImporter> map = new ConcurrentHashMap<String, GatewayDescriptorImporter>();
        map.put("xml", new XmlGatewayDescriptorImporter());
        return map;
    }

    private static Map<String, GatewayDescriptorExporter> loadExporters() {
        ConcurrentHashMap<String, GatewayDescriptorExporter> map = new ConcurrentHashMap<String, GatewayDescriptorExporter>();
        map.put("xml", new XmlGatewayDescriptorExporter());
        return map;
    }
}

