/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestTimeLimit
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestTimeLimit.class);

    public StoreSearchRequestTimeLimit() {
        super("Store SearchRequest timeLimit");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        SearchRequest searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            int timeLimit = IntegerDecoder.parse((BerValue)value, (int)0, (int)Integer.MAX_VALUE);
            searchRequest.setTimeLimit(timeLimit);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err((I18n)I18n.ERR_05152_BAD_TIME_LIMIT, (Object[])new Object[]{value.toString()});
            LOG.error(msg);
            throw new DecoderException(msg, (Throwable)ide);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05164_TIME_LIMIT_SET_TO, (Object[])new Object[]{searchRequest.getTimeLimit()}));
        }
    }
}

