/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.BackwardCompatibilityConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.annotation.ConfigTag;
import org.apache.kylin.common.lock.DistributedLockFactory;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ParameterFilter;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KylinConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfigBase.class);
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    private static final String DEFAULT = "default";
    private static final String KYLIN_ENGINE_MR_JOB_JAR = "kylin.engine.mr.job-jar";
    private static final String KYLIN_ENGINE_PARQUET_JOB_JAR = "kylin.engine.parquet.job-jar";
    private static final String KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR = "kylin.storage.hbase.coprocessor-local-jar";
    private static final String FILE_SCHEME = "file:";
    private static final String MAPRFS_SCHEME = "maprfs:";
    private static final Pattern COPROCESSOR_JAR_NAME_PATTERN = Pattern.compile("kylin-coprocessor-(.+)\\.jar");
    private static final Pattern JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-job-(.+)\\.jar");
    private static final Pattern PARQUET_JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-parquet-job-(.+)\\.jar");
    static BackwardCompatibilityConfig BCC = new BackwardCompatibilityConfig();
    volatile Properties properties = new Properties();
    private String cachedHdfsWorkingDirectory;
    private String cachedBigCellDirectory;

    public KylinConfigBase() {
        this(new Properties());
    }

    public KylinConfigBase(Properties props) {
        this.properties = BCC.check(props);
    }

    protected KylinConfigBase(Properties props, boolean force) {
        this.properties = force ? props : BCC.check(props);
    }

    public static String getKylinConfHome() {
        String kylinConfHome = KylinConfigBase.getKylinConfHomeWithoutWarn();
        if (StringUtils.isEmpty(kylinConfHome)) {
            logger.warn("KYLIN_CONF was not set");
        }
        return kylinConfHome;
    }

    public static String getKylinConfHomeWithoutWarn() {
        String kylinConfHome = System.getenv("KYLIN_CONF");
        if (StringUtils.isEmpty(kylinConfHome)) {
            kylinConfHome = System.getProperty("KYLIN_CONF");
        }
        return kylinConfHome;
    }

    public static String getKylinHome() {
        String kylinHome = KylinConfigBase.getKylinHomeWithoutWarn();
        if (StringUtils.isEmpty(kylinHome)) {
            logger.warn("KYLIN_HOME was not set");
        }
        return kylinHome;
    }

    public static String getKylinHomeWithoutWarn() {
        String kylinHome = System.getenv("KYLIN_HOME");
        if (StringUtils.isEmpty(kylinHome)) {
            kylinHome = System.getProperty("KYLIN_HOME");
        }
        return kylinHome;
    }

    public static String getSparkHome() {
        String sparkHome = System.getenv("SPARK_HOME");
        if (StringUtils.isNotEmpty(sparkHome)) {
            logger.info("SPARK_HOME was set to {}", (Object)sparkHome);
            return sparkHome;
        }
        sparkHome = System.getProperty("SPARK_HOME");
        if (StringUtils.isNotEmpty(sparkHome)) {
            logger.info("SPARK_HOME was set to {}", (Object)sparkHome);
            return sparkHome;
        }
        return KylinConfigBase.getKylinHome() + File.separator + "spark";
    }

    private static String getFileName(String homePath, Pattern pattern) {
        File[] listFiles;
        File home = new File(homePath);
        TreeSet<String> files = Sets.newTreeSet();
        if (home.exists() && home.isDirectory() && (listFiles = home.listFiles()) != null) {
            for (File file : listFiles) {
                Matcher matcher = pattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if (files.isEmpty()) {
            throw new RuntimeException("cannot find " + pattern.toString() + " in " + homePath);
        }
        return (String)files.last();
    }

    protected final String getOptional(String prop) {
        return this.getOptional(prop, null);
    }

    protected String getOptional(String prop, String dft) {
        String string;
        String property = System.getProperty(prop);
        if (property != null) {
            this.getSubstitutor();
            string = StrSubstitutor.replace((Object)property, System.getenv());
        } else {
            this.getSubstitutor();
            string = StrSubstitutor.replace((Object)this.properties.getProperty(prop, dft), System.getenv());
        }
        return string;
    }

    protected Properties getAllProperties() {
        return this.getProperties(null);
    }

    protected Properties getProperties(Collection<String> propertyKeys) {
        StrSubstitutor sub = this.getSubstitutor();
        Properties filteredProperties = new Properties();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            if (propertyKeys != null && !propertyKeys.contains(entry.getKey())) continue;
            filteredProperties.put(entry.getKey(), sub.replace((String)entry.getValue()));
        }
        return filteredProperties;
    }

    protected StrSubstitutor getSubstitutor() {
        HashMap<Object, Object> all = Maps.newHashMap();
        all.putAll(this.properties);
        all.putAll(System.getenv());
        return new StrSubstitutor(all);
    }

    protected Properties getRawAllProperties() {
        return this.properties;
    }

    protected final Map<String, String> getPropertiesByPrefix(String prefix) {
        LinkedHashMap<String, String> result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : this.getAllProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    protected final String[] getOptionalStringArray(String prop, String[] dft) {
        String property = this.getOptional(prop);
        if (!StringUtils.isBlank(property)) {
            return property.split("\\s*,\\s*");
        }
        return dft;
    }

    protected final int[] getOptionalIntArray(String prop, String[] dft) {
        String[] strArray = this.getOptionalStringArray(prop, dft);
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    protected final String getRequired(String prop) {
        String r = this.getOptional(prop);
        if (StringUtils.isEmpty(r)) {
            throw new IllegalArgumentException("missing '" + prop + "' in conf/kylin.properties");
        }
        return r;
    }

    public final void setProperty(String key, String value) {
        logger.info("Kylin Config was updated with {} : {}", (Object)key, (Object)value);
        this.properties.setProperty(BCC.check(key), value);
    }

    protected final void reloadKylinConfig(Properties properties) {
        this.properties = BCC.check(properties);
        this.setProperty("kylin.metadata.url.identifier", this.getMetadataUrlPrefix());
    }

    private Map<Integer, String> convertKeyToInteger(Map<String, String> map) {
        LinkedHashMap<Integer, String> result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Integer.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return this.getMetadataUrl().toString();
    }

    public boolean isDevEnv() {
        return "DEV".equals(this.getOptional("kylin.env", "DEV")) || "UT".equals(this.getOptional("kylin.env", "DEV")) || "LOCAL".equals(this.getOptional("kylin.env", "DEV"));
    }

    public String getDeployEnv() {
        return this.getOptional("kylin.env", "DEV");
    }

    public String getHdfsWorkingDirectory() {
        return this.getHdfsWorkingDirectoryInternal(HadoopUtil.getCurrentConfiguration());
    }

    public String getHdfsWorkingDirectoryInternal(Configuration hadoopConf) {
        if (this.cachedHdfsWorkingDirectory != null) {
            return this.cachedHdfsWorkingDirectory;
        }
        String root = this.getOptional("kylin.env.hdfs-working-dir", "/kylin");
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-working-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = path.getFileSystem(hadoopConf);
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String metaId = this.getMetadataUrlPrefix().replace(':', '-');
        if (metaId.startsWith("../")) {
            metaId = metaId.replace("../", "");
            metaId = metaId.replace('/', '-');
        }
        if (!(root = new Path(path, metaId).toString()).endsWith("/")) {
            root = root + "/";
        }
        this.cachedHdfsWorkingDirectory = root;
        if (this.cachedHdfsWorkingDirectory.startsWith(FILE_SCHEME)) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace(FILE_SCHEME, "file://");
        } else if (this.cachedHdfsWorkingDirectory.startsWith(MAPRFS_SCHEME)) {
            this.cachedHdfsWorkingDirectory = this.cachedHdfsWorkingDirectory.replace(MAPRFS_SCHEME, "maprfs://");
        }
        return this.cachedHdfsWorkingDirectory;
    }

    public String getMetastoreBigCellHdfsDirectory() {
        if (this.cachedBigCellDirectory != null) {
            return this.cachedBigCellDirectory;
        }
        String root = this.getOptional("kylin.env.hdfs-metastore-bigcell-dir");
        if (root == null) {
            return this.getJdbcHdfsWorkingDirectory();
        }
        Path path = new Path(root);
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("kylin.env.hdfs-metastore-bigcell-dir must be absolute, but got " + root);
        }
        try {
            FileSystem fs = HadoopUtil.getReadFileSystem();
            path = fs.makeQualified(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        root = new Path(path, StringUtils.replaceChars(this.getMetadataUrlPrefix(), ':', '-')).toString();
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        this.cachedBigCellDirectory = root;
        if (this.cachedBigCellDirectory.startsWith(FILE_SCHEME)) {
            this.cachedBigCellDirectory = this.cachedBigCellDirectory.replace(FILE_SCHEME, "file://");
        } else if (this.cachedBigCellDirectory.startsWith(MAPRFS_SCHEME)) {
            this.cachedBigCellDirectory = this.cachedBigCellDirectory.replace(MAPRFS_SCHEME, "maprfs://");
        }
        return this.cachedBigCellDirectory;
    }

    public String getReadHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty(this.getHBaseClusterFs())) {
            Path workingDir = new Path(this.getHdfsWorkingDirectory());
            return new Path(this.getHBaseClusterFs(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + "/";
        }
        return this.getHdfsWorkingDirectory();
    }

    private String getJdbcHdfsWorkingDirectory() {
        if (StringUtils.isNotEmpty(this.getJdbcFileSystem())) {
            Path workingDir = new Path(this.getReadHdfsWorkingDirectory());
            return new Path(this.getJdbcFileSystem(), Path.getPathWithoutSchemeAndAuthority((Path)workingDir)).toString() + "/";
        }
        return this.getReadHdfsWorkingDirectory();
    }

    private String getJdbcFileSystem() {
        return this.getOptional("kylin.storage.columnar.jdbc.file-system", "");
    }

    public String getHdfsWorkingDirectory(String project) {
        if (this.isProjectIsolationEnabled() && project != null) {
            return new Path(this.getHdfsWorkingDirectory(), project).toString() + "/";
        }
        return this.getHdfsWorkingDirectory();
    }

    public String getZookeeperBasePath() {
        return this.getOptional("kylin.env.zookeeper-base-path", "/kylin");
    }

    public String getZookeeperConnectString() {
        if (this.isZKLocal()) {
            return "localhost:12181";
        }
        return this.getOptional("kylin.env.zookeeper-connect-string");
    }

    public int getZKBaseSleepTimeMs() {
        return Integer.parseInt(this.getOptional("kylin.env.zookeeper-base-sleep-time", "3000"));
    }

    public int getZKMaxRetries() {
        return Integer.parseInt(this.getOptional("kylin.env.zookeeper-max-retries", "3"));
    }

    public int getZKMonitorInterval() {
        return Integer.parseInt(this.getOptional("kylin.job.zookeeper-monitor-interval", "30"));
    }

    public boolean isZKLocal() {
        return Boolean.parseBoolean(this.getOptional("kylin.env.zookeeper-is-local", FALSE));
    }

    public String[] getRestServersWithMode() {
        return this.getOptionalStringArray("kylin.server.cluster-servers-with-mode", new String[0]);
    }

    public StorageURL getMetadataUrl() {
        return StorageURL.valueOf(this.getOptional("kylin.metadata.url", "kylin_metadata@hbase"));
    }

    public void setMetadataUrl(String metadataUrl) {
        this.setProperty("kylin.metadata.url", metadataUrl);
    }

    public int getCacheSyncRetrys() {
        return Integer.parseInt(this.getOptional("kylin.metadata.sync-retries", "3"));
    }

    public String getCacheSyncErrorHandler() {
        return this.getOptional("kylin.metadata.sync-error-handler");
    }

    public String getMetadataUrlPrefix() {
        return this.getMetadataUrl().getIdentifier();
    }

    public Map<String, String> getResourceStoreImpls() {
        LinkedHashMap<String, String> r = Maps.newLinkedHashMap();
        r.put("", "org.apache.kylin.common.persistence.FileResourceStore");
        r.put("hbase", "org.apache.kylin.storage.hbase.HBaseResourceStore");
        r.put("hdfs", "org.apache.kylin.common.persistence.HDFSResourceStore");
        r.put("ifile", "org.apache.kylin.common.persistence.IdentifierFileResourceStore");
        r.put("jdbc", "org.apache.kylin.common.persistence.JDBCResourceStore");
        r.putAll(this.getPropertiesByPrefix("kylin.metadata.resource-store-provider."));
        return r;
    }

    public boolean isResourceStoreReconnectEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.resourcestore.reconnect-enabled", FALSE));
    }

    public int getResourceStoreReconnectBaseMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-base-ms", "1000"));
    }

    public int getResourceStoreReconnectMaxMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-max-ms", "60000"));
    }

    public int getResourceStoreReconnectTimeoutMs() {
        return Integer.parseInt(this.getOptional("kylin.resourcestore.reconnect-timeout-ms", "3600000"));
    }

    public String getResourceStoreConnectionExceptions() {
        return this.getOptional("kylin.resourcestore.connection-exceptions", "");
    }

    public String getDataModelImpl() {
        return this.getOptional("kylin.metadata.data-model-impl", null);
    }

    public String getDataModelManagerImpl() {
        return this.getOptional("kylin.metadata.data-model-manager-impl", null);
    }

    public String[] getRealizationProviders() {
        return this.getOptionalStringArray("kylin.metadata.realization-providers", new String[]{"org.apache.kylin.cube.CubeManager", "org.apache.kylin.storage.hybrid.HybridManager"});
    }

    public String[] getCubeDimensionCustomEncodingFactories() {
        return this.getOptionalStringArray("kylin.metadata.custom-dimension-encodings", new String[0]);
    }

    public Map<String, String> getCubeCustomMeasureTypes() {
        return this.getPropertiesByPrefix("kylin.metadata.custom-measure-types.");
    }

    public DistributedLockFactory getDistributedLockFactory() {
        String clsName = this.getOptional("kylin.metadata.distributed-lock-impl", "org.apache.kylin.job.lock.zookeeper.ZookeeperDistributedLock$Factory");
        return (DistributedLockFactory)ClassUtil.newInstance(clsName);
    }

    public String getHBaseMappingAdapter() {
        return this.getOptional("kylin.metadata.hbasemapping-adapter");
    }

    public boolean isCheckCopyOnWrite() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.check-copy-on-write", FALSE));
    }

    public String getHbaseClientScannerTimeoutPeriod() {
        return this.getOptional("kylin.metadata.hbase-client-scanner-timeout-period", "10000");
    }

    public String getHbaseRpcTimeout() {
        return this.getOptional("kylin.metadata.hbase-rpc-timeout", "5000");
    }

    public String getHbaseClientRetriesNumber() {
        return this.getOptional("kylin.metadata.hbase-client-retries-number", "1");
    }

    public boolean isModelSchemaUpdaterCheckerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.model-schema-updater-checker-enabled", FALSE));
    }

    public boolean isAbleChangeStringToDateTime() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.able-change-string-to-datetime", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String[] getMrHiveDictColumns() {
        String columnStr = this.getOptional("kylin.dictionary.mr-hive.columns", "");
        if (!columnStr.equals("")) {
            return columnStr.split(",");
        }
        return new String[0];
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getMrHiveDictDB() {
        return this.getOptional("kylin.dictionary.mr-hive.database", this.getHiveDatabaseForIntermediateTable());
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getMrHiveDictTableSuffix() {
        return this.getOptional("kylin.dictionary.mr-hive.table.suffix", "_global_dict");
    }

    public String getCuboidScheduler() {
        return this.getOptional("kylin.cube.cuboid-scheduler", "org.apache.kylin.cube.cuboid.DefaultCuboidScheduler");
    }

    public boolean isRowKeyEncodingAutoConvert() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.kylin.cube.rowkey-encoding-auto-convert", TRUE));
    }

    public String getSegmentAdvisor() {
        return this.getOptional("kylin.cube.segment-advisor", "org.apache.kylin.cube.CubeSegmentAdvisor");
    }

    public boolean enableJobCuboidSizeOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.size-estimate-enable-optimize", FALSE));
    }

    public double getJobCuboidSizeCountDistinctRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-countdistinct-ratio", "0.5"));
    }

    public double getJobCuboidSizeTopNRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.size-estimate-topn-ratio", "0.5"));
    }

    public String getCubeAlgorithm() {
        return this.getOptional("kylin.cube.algorithm", "auto");
    }

    public double getCubeAlgorithmAutoThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.algorithm.layer-or-inmem-threshold", "7"));
    }

    public boolean isAutoInmemToOptimize() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.algorithm.inmem-auto-optimize", TRUE));
    }

    public int getCubeAlgorithmAutoMapperLimit() {
        return Integer.parseInt(this.getOptional("kylin.cube.algorithm.inmem-split-limit", "500"));
    }

    public boolean isIgnoreCubeSignatureInconsistency() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.ignore-signature-inconsistency", FALSE));
    }

    public long getCubeAggrGroupMaxCombination() {
        return Long.parseLong(this.getOptional("kylin.cube.aggrgroup.max-combination", "32768"));
    }

    public boolean getCubeAggrGroupIsMandatoryOnlyValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.is-mandatory-only-valid", FALSE));
    }

    public int getCubeRowkeyMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.rowkey.max-size", "63"));
    }

    public int getDimensionEncodingMaxLength() {
        return Integer.parseInt(this.getOptional("kylin.metadata.dimension-encoding-max-length", "256"));
    }

    public int getMaxBuildingSegments() {
        return Integer.parseInt(this.getOptional("kylin.cube.max-building-segments", "10"));
    }

    public long getMaxSegmentMergeSpan() {
        return Long.parseLong(this.getOptional("kylin.cube.max-segment-merge.span", "-1"));
    }

    public boolean allowCubeAppearInMultipleProjects() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.allow-appear-in-multiple-projects", FALSE));
    }

    public int getGTScanRequestSerializationLevel() {
        return Integer.parseInt(this.getOptional("kylin.cube.gtscanrequest-serialization-level", "1"));
    }

    public boolean isAutoMergeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.is-automerge-enabled", TRUE));
    }

    public String[] getCubeMetadataExtraValidators() {
        return this.getOptionalStringArray("kylin.cube.metadata-extra-validators", new String[0]);
    }

    public boolean isCubePlannerEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled", FALSE));
    }

    public boolean isCubePlannerEnabledForExistingCube() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.cubeplanner.enabled-for-existing-cube", TRUE));
    }

    public double getCubePlannerExpansionRateThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.expansion-threshold", "2.5"));
    }

    public int getCubePlannerRecommendCuboidCacheMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.recommend-cache-max-size", "200"));
    }

    public double getCubePlannerQueryUncertaintyRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.query-uncertainty-ratio", "0.1"));
    }

    public double getCubePlannerBPUSMinBenefitRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.bpus-min-benefit-ratio", "0.01"));
    }

    public int getCubePlannerAgreedyAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-greedy", "8"));
    }

    public int getCubePlannerGeneticAlgorithmAutoThreshold() {
        return Integer.parseInt(this.getOptional("kylin.cube.cubeplanner.algorithm-threshold-genetic", "23"));
    }

    public double getStorageCompressionRatio() {
        return Double.parseDouble(this.getOptional("kylin.cube.cubeplanner.storage.compression.ratio", "0.2"));
    }

    public String[] getAssignedServers() {
        return this.getOptionalStringArray("kylin.cube.schedule.assigned-servers", new String[0]);
    }

    public boolean isOnAssignedServer(String ... targetServers) {
        String[] servers = this.getAssignedServers();
        if (null == servers || servers.length == 0) {
            return true;
        }
        for (String s : servers) {
            for (String ts : targetServers) {
                if (!s.equalsIgnoreCase(ts)) continue;
                return true;
            }
        }
        return false;
    }

    public CliCommandExecutor getCliCommandExecutor() {
        CliCommandExecutor exec = new CliCommandExecutor();
        if (this.getRunAsRemoteCommand()) {
            exec.setRunAtRemote(this.getRemoteHadoopCliHostname(), this.getRemoteHadoopCliPort(), this.getRemoteHadoopCliUsername(), this.getRemoteHadoopCliPassword());
        }
        return exec;
    }

    public String getKylinJobLogDir() {
        return this.getOptional("kylin.job.log-dir", "/tmp/kylin/logs");
    }

    public String getKylinLogDir() {
        String kylinHome = KylinConfigBase.getKylinHome();
        if (kylinHome == null) {
            kylinHome = System.getProperty("KYLIN_HOME");
        }
        return kylinHome + File.separator + "logs";
    }

    public boolean getRunAsRemoteCommand() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-remote-cli"));
    }

    public int getRemoteHadoopCliPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote-cli-port", "22"));
    }

    public String getRemoteHadoopCliHostname() {
        return this.getOptional("kylin.job.remote-cli-hostname");
    }

    public String getRemoteHadoopCliUsername() {
        return this.getOptional("kylin.job.remote-cli-username");
    }

    public String getRemoteHadoopCliPassword() {
        return this.getOptional("kylin.job.remote-cli-password");
    }

    public String getCliWorkingDir() {
        return this.getOptional("kylin.job.remote-cli-working-dir");
    }

    public boolean isEmptySegmentAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.allow-empty-segment", TRUE));
    }

    public int getMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.max-concurrent-jobs", "10"));
    }

    public String getHiveDependencyFilterList() {
        return this.getOptional("kylin.job.dependency-filter-list", "[^,]*hive-exec[^,]*?\\.jar|[^,]*hive-metastore[^,]*?\\.jar|[^,]*hive-hcatalog-core[^,]*?\\.jar");
    }

    public boolean isMailEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-enabled", FALSE));
    }

    public boolean isStarttlsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.notification-mail-enable-starttls", FALSE));
    }

    public String getSmtpPort() {
        return this.getOptional("kylin.job.notification-mail-port", "25");
    }

    public String getMailHost() {
        return this.getOptional("kylin.job.notification-mail-host", "");
    }

    public String getMailUsername() {
        return this.getOptional("kylin.job.notification-mail-username", "");
    }

    public String getMailPassword() {
        return this.getOptional("kylin.job.notification-mail-password", "");
    }

    public String getMailSender() {
        return this.getOptional("kylin.job.notification-mail-sender", "");
    }

    public String[] getAdminDls() {
        return this.getOptionalStringArray("kylin.job.notification-admin-emails", null);
    }

    public int getJobRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.retry", "0"));
    }

    public int getJobRetryInterval() {
        return Integer.parseInt(this.getOptional("kylin.job.retry-interval", "30000"));
    }

    public String[] getJobRetryExceptions() {
        return this.getOptionalStringArray("kylin.job.retry-exception-classes", new String[0]);
    }

    public int getCubeStatsHLLPrecision() {
        return Integer.parseInt(this.getOptional("kylin.job.sampling-hll-precision", "14"));
    }

    public Map<Integer, String> getSchedulers() {
        LinkedHashMap<Integer, String> r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.job.impl.threadpool.DefaultScheduler");
        r.put(2, "org.apache.kylin.job.impl.threadpool.DistributedScheduler");
        r.put(77, "org.apache.kylin.job.impl.threadpool.NoopScheduler");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.job.scheduler.provider.")));
        return r;
    }

    public Integer getSchedulerType() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.default", "0"));
    }

    public boolean getSchedulerPriorityConsidered() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.scheduler.priority-considered", FALSE));
    }

    public Integer getSchedulerPriorityBarFetchFromQueue() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.priority-bar-fetch-from-queue", "20"));
    }

    public Integer getSchedulerPollIntervalSecond() {
        return Integer.parseInt(this.getOptional("kylin.job.scheduler.poll-interval-second", "30"));
    }

    public boolean isSchedulerSafeMode() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.scheduler.safemode", FALSE));
    }

    public List<String> getSafeModeRunnableProjects() {
        return Arrays.asList(this.getOptionalStringArray("kylin.job.scheduler.safemode.runnable-projects", new String[0]));
    }

    public boolean isAdvancedFlatTableUsed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.use-advanced-flat-table", FALSE));
    }

    public String getAdvancedFlatTableClass() {
        return this.getOptional("kylin.job.advanced-flat-table.class");
    }

    public String getJobTrackingURLPattern() {
        return this.getOptional("kylin.job.tracking-url-pattern", "");
    }

    public int getJobMetadataPersistRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.metadata-persist-retry", "5"));
    }

    public boolean isJobAutoReadyCubeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.cube-auto-ready-enabled", TRUE));
    }

    public int getJobOutputMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.job.execute-output.max-size", "10485760"));
    }

    public int getDefaultSource() {
        return Integer.parseInt(this.getOptional("kylin.source.default", "0"));
    }

    public Map<Integer, String> getSourceEngines() {
        LinkedHashMap<Integer, String> r = Maps.newLinkedHashMap();
        r.put(0, "org.apache.kylin.source.hive.HiveSource");
        r.put(9, "org.apache.kylin.engine.spark.source.CsvSource");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.provider.")));
        return r;
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public boolean enableHiveDdlQuote() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.quote-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getFactTableDialect() {
        return this.getOptional("kylin.fact.table.dialect", "hive");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHiveUrl() {
        return this.getOptional("kylin.source.hive.connection-url", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHiveUser() {
        return this.getOptional("kylin.source.hive.connection-user", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHivePassword() {
        return this.getOptional("kylin.source.hive.connection-password", "");
    }

    public Map<String, String> getHiveConfigOverride() {
        return this.getPropertiesByPrefix("kylin.source.hive.config-override.");
    }

    public String getOverrideHiveTableLocation(String table) {
        return this.getOptional("kylin.source.hive.table-location." + table.toUpperCase(Locale.ROOT));
    }

    public boolean isHiveKeepFlatTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.keep-flat-table", FALSE));
    }

    public String getHiveDatabaseForIntermediateTable() {
        return ParameterFilter.checkHiveProperty(this.getOptional("kylin.source.hive.database-for-flat-table", DEFAULT));
    }

    public String getFlatTableStorageFormat() {
        return this.getOptional("kylin.source.hive.flat-table-storage-format", "SEQUENCEFILE");
    }

    public String getFlatTableFieldDelimiter() {
        return this.getOptional("kylin.source.hive.flat-table-field-delimiter", "\u001f");
    }

    public boolean isHiveRedistributeEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.redistribute-flat-table", TRUE));
    }

    public String getHiveClientMode() {
        return this.getOptional("kylin.source.hive.client", "spark_catalog");
    }

    public String getHiveBeelineShell() {
        return this.getOptional("kylin.source.hive.beeline-shell", "beeline");
    }

    public String getHiveBeelineParams() {
        return this.getOptional("kylin.source.hive.beeline-params", "");
    }

    public boolean getEnableSparkSqlForTableOps() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.enable-sparksql-for-table-ops", FALSE));
    }

    public String getSparkSqlBeelineShell() {
        return this.getOptional("kylin.source.hive.sparksql-beeline-shell", "");
    }

    public String getSparkSqlBeelineParams() {
        return this.getOptional("kylin.source.hive.sparksql-beeline-params", "");
    }

    public boolean getHiveTableDirCreateFirst() {
        return Boolean.parseBoolean(this.getOptional("kylin.source.hive.table-dir-create-first", FALSE));
    }

    public String getFlatHiveTableClusterByDictColumn() {
        return this.getOptional("kylin.source.hive.flat-table-cluster-by-dict-column");
    }

    public int getHiveRedistributeColumnCount() {
        return Integer.parseInt(this.getOptional("kylin.source.hive.redistribute-column-count", "3"));
    }

    public int getDefaultVarcharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-varchar-precision", "256"));
        if (v < 1) {
            return 256;
        }
        if (v > 65535) {
            return 65535;
        }
        return v;
    }

    public int getDefaultCharPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-char-precision", "255"));
        if (v < 1) {
            return 255;
        }
        if (v > 255) {
            return 255;
        }
        return v;
    }

    public int getDefaultDecimalPrecision() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-precision", "19"));
        if (v < 1) {
            return 19;
        }
        return v;
    }

    public int getDefaultDecimalScale() {
        int v = Integer.parseInt(this.getOptional("kylin.source.hive.default-decimal-scale", "4"));
        if (v < 1) {
            return 4;
        }
        return v;
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHiveIntermediateTablePrefix() {
        return this.getOptional("kylin.source.hive.intermediate-table-prefix", "kylin_intermediate_");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHiveMetaDataType() {
        return this.getOptional("kylin.source.hive.metadata-type", "hcatalog");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourceConnectionUrl() {
        return this.getOptional("kylin.source.jdbc.connection-url");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourceDriver() {
        return this.getOptional("kylin.source.jdbc.driver");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourceDialect() {
        return this.getOptional("kylin.source.jdbc.dialect", DEFAULT);
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourceUser() {
        return this.getOptional("kylin.source.jdbc.user");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourcePass() {
        return this.getOptional("kylin.source.jdbc.pass");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_IMPLEMENTED})
    public String getJdbcSourceFieldDelimiter() {
        return this.getOptional("kylin.source.jdbc.field-delimiter", "|");
    }

    public Map<Integer, String> getStorageEngines() {
        LinkedHashMap<Integer, String> r = Maps.newLinkedHashMap();
        r.put(1, "org.apache.kylin.storage.hybrid.HybridStorage");
        r.put(4, "org.apache.kylin.engine.spark.storage.ParquetDataStorage");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.storage.provider.")));
        return r;
    }

    public StorageURL getStorageUrl() {
        String url = this.getOptional("kylin.storage.url", "default@hbase");
        if ("hbase".equals(url)) {
            url = "default@hbase";
        }
        return StorageURL.valueOf(url);
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHBaseTableNamePrefix() {
        return this.getOptional("kylin.storage.hbase.table-name-prefix", "KYLIN_");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHBaseStorageNameSpace() {
        return this.getOptional("kylin.storage.hbase.namespace", DEFAULT);
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHBaseClusterFs() {
        return this.getOptional("kylin.storage.hbase.cluster-fs", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHBaseClusterHDFSConfigFile() {
        return this.getOptional("kylin.storage.hbase.cluster-hdfs-config-file", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public void overrideCoprocessorLocalJar(String path) {
        logger.info("override {} to {}", (Object)KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR, (Object)path);
        System.setProperty(KYLIN_STORAGE_HBASE_COPROCESSOR_LOCAL_JAR, path);
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public double getQueryCoprocessorMemGB() {
        return Double.parseDouble(this.getOptional("kylin.storage.hbase.coprocessor-mem-gb", "3.0"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getQueryScanFuzzyKeyMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-fuzzykey-scan", "200"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getQueryScanFuzzyKeySplitMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-fuzzykey-scan-split", "1"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getQueryStorageVisitScanRangeMax() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-visit-scanrange", "1000000"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getHBaseScanCacheRows() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.scan-cache-rows", "1024"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getHBaseScanMaxResultSize() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-scan-result-bytes", "5242880"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHbaseDefaultCompressionCodec() {
        return this.getOptional("kylin.storage.hbase.compression-codec", "none");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getKylinOwner() {
        return this.getOptional("kylin.storage.hbase.owner-tag", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getHBaseMaxConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.max-hconnection-threads", "2048"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public int getHBaseCoreConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.storage.hbase.core-hconnection-threads", "2048"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public long getHBaseConnectionThreadPoolAliveSeconds() {
        return Long.parseLong(this.getOptional("kylin.storage.hbase.hconnection-threads-alive-seconds", "60"));
    }

    public boolean cleanStorageAfterDelOperation() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.clean-after-delete-operation", FALSE));
    }

    public Map<Integer, String> getJobEngines() {
        LinkedHashMap<Integer, String> r = Maps.newLinkedHashMap();
        r.put(6, "org.apache.kylin.engine.spark.SparkBatchCubingEngineParquet");
        r.putAll(this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.engine.provider.")));
        return r;
    }

    public int getDefaultCubeEngine() {
        return Integer.parseInt(this.getOptional("kylin.engine.default", "6"));
    }

    public String getKylinJobJarPath() {
        String jobJar = this.getOptional(KYLIN_ENGINE_MR_JOB_JAR);
        if (StringUtils.isNotEmpty(jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty(kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
    }

    public void overrideMRJobJarPath(String path) {
        logger.info("override {} to {}", (Object)KYLIN_ENGINE_MR_JOB_JAR, (Object)path);
        System.setProperty(KYLIN_ENGINE_MR_JOB_JAR, path);
    }

    public String getKylinJobMRLibDir() {
        return this.getOptional("kylin.engine.mr.lib-dir", "");
    }

    public Map<String, String> getMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.config-override.");
    }

    public Map<String, String> getMemHungryConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.mr.mem-hungry-config-override.");
    }

    public Map<String, String> getSparkConfigOverride() {
        return this.getPropertiesByPrefix("kylin.engine.spark-conf.");
    }

    public String getSparkEngineConfigOverrideWithSpecificName(String configName) {
        Map<String, String> config = this.getPropertiesByPrefix("kylin.engine.spark-conf." + configName);
        if (config.size() != 0) {
            return String.valueOf(config.values().iterator().next());
        }
        return null;
    }

    public String getSparderConfigOverrideWithSpecificName(String configName) {
        Map<String, String> config = this.getPropertiesByPrefix("kylin.query.spark-conf." + configName);
        if (config.size() != 0) {
            return String.valueOf(config.values().iterator().next());
        }
        return null;
    }

    public double getDefaultHadoopJobReducerInputMB() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-input-mb", "500"));
    }

    public double getDefaultHadoopJobReducerCountRatio() {
        return Double.parseDouble(this.getOptional("kylin.engine.mr.reduce-count-ratio", "1.0"));
    }

    public int getHadoopJobMinReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.min-reducer-number", "1"));
    }

    public int getHadoopJobMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.max-reducer-number", "500"));
    }

    public int getHadoopJobMapperInputRows() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.mapper-input-rows", "1000000"));
    }

    public int getHadoopJobPerReducerHLLCuboidNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.per-reducer-hll-cuboid-number", "100"));
    }

    public int getHadoopJobHLLMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.hll-max-reducer-number", "1"));
    }

    public String getYarnStatusCheckUrl() {
        return this.getOptional("kylin.engine.mr.yarn-check-status-url", null);
    }

    public int getYarnStatusCheckIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.engine.mr.yarn-check-interval-seconds", "10"));
    }

    public boolean isUseLocalClasspathEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.mr.use-local-classpath", TRUE));
    }

    public String getHiveUnionStyle() {
        return this.getOptional("kylin.hive.union.style", "UNION");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public boolean isLivyEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.livy-conf.livy-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getLivyRestApiBacktick() {
        return this.getOptional("kylin.engine.livy.backtick.quote", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getLivyUrl() {
        return this.getOptional("kylin.engine.livy-conf.livy-url");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public Map<String, String> getLivyKey() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-key.");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public Map<String, String> getLivyArr() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-arr.");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public Map<String, String> getLivyMap() {
        return this.getPropertiesByPrefix("kylin.engine.livy-conf.livy-map.");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public boolean isDictionaryEnumeratorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enable-dict-enumerator", FALSE));
    }

    public boolean isEnumerableRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.enumerable-rules-enabled", FALSE));
    }

    public boolean isReduceExpressionsRulesEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.calcite.reduce-rules-enabled", TRUE));
    }

    public boolean isConvertCreateTableToWith() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.convert-create-table-to-with", FALSE));
    }

    public Properties getCalciteExtrasProperties() {
        Properties properties = new Properties();
        Map<String, String> map = this.getPropertiesByPrefix("kylin.query.calcite.extras-props.");
        properties.putAll(map);
        return properties;
    }

    public List<String> getCalciteAddRule() {
        String rules = this.getOptional("kylin.query.calcite.add-rule");
        if (rules == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(rules.split(","));
    }

    public List<String> getCalciteRemoveRule() {
        String rules = this.getOptional("kylin.query.calcite.remove-rule");
        if (rules == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList(rules.split(","));
    }

    public boolean isDynamicColumnEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enable-dynamic-column", FALSE));
    }

    public boolean isSkippingEmptySegments() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.skip-empty-segments", TRUE));
    }

    public boolean isDisableCubeNoAggSQL() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.disable-cube-noagg-sql", FALSE));
    }

    public boolean isStreamAggregateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.stream-aggregate-enabled", TRUE));
    }

    public boolean isProjectIsolationEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.project-isolation-enable", TRUE));
    }

    @Deprecated
    public int getStoragePushDownLimitMax() {
        return Integer.parseInt(this.getOptional("kylin.query.max-limit-pushdown", "10000"));
    }

    public int getForceLimit() {
        return Integer.parseInt(this.getOptional("kylin.query.force-limit", "-1"));
    }

    @Deprecated
    public int getScanThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.scan-threshold", "10000000"));
    }

    public boolean isLazyQueryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.lazy-query-enabled", FALSE));
    }

    public long getLazyQueryWaitingTimeoutMilliSeconds() {
        return Long.parseLong(this.getOptional("kylin.query.lazy-query-waiting-timeout-milliseconds", "60000"));
    }

    public int getQueryConcurrentRunningThresholdForProject() {
        return Integer.parseInt(this.getOptional("kylin.query.project-concurrent-running-threshold", "0"));
    }

    public int getLargeQueryThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.large-query-threshold", String.valueOf(1000000)));
    }

    public int getDerivedInThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.derived-filter-translation-threshold", "20"));
    }

    public int getBadQueryStackTraceDepth() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-stacktrace-depth", "10"));
    }

    public int getBadQueryHistoryNum() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-history-number", "50"));
    }

    public int getBadQueryDefaultAlertingSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery-alerting-seconds", "90"));
    }

    public double getBadQueryDefaultAlertingCoefficient() {
        return Double.parseDouble(this.getOptional("kylin.query.timeout-seconds-coefficient", "0.5"));
    }

    public int getBadQueryDefaultDetectIntervalSeconds() {
        int time = (int)((double)this.getQueryTimeoutSeconds() * this.getBadQueryDefaultAlertingCoefficient());
        if (time == 0) {
            time = 60;
        }
        return time;
    }

    public boolean getBadQueryPersistentEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.badquery-persistent-enabled", TRUE));
    }

    public String[] getQueryTransformers() {
        return this.getOptionalStringArray("kylin.query.transformers", new String[0]);
    }

    public String[] getQueryInterceptors() {
        return this.getOptionalStringArray("kylin.query.interceptors", new String[0]);
    }

    public long getQueryDurationCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-duration", String.valueOf(2000)));
    }

    public long getQueryScanCountCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-count", String.valueOf(10240)));
    }

    public long getQueryScanBytesCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache-threshold-scan-bytes", String.valueOf(0x100000)));
    }

    public boolean isQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-enabled", TRUE));
    }

    public boolean isQueryIgnoreUnknownFunction() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.ignore-unknown-function", FALSE));
    }

    public boolean isMemcachedEnabled() {
        return !StringUtil.isEmpty(this.getMemCachedHosts());
    }

    public String getMemCachedHosts() {
        return this.getOptional("kylin.cache.memcached.hosts", null);
    }

    public String getQueryAccessController() {
        return this.getOptional("kylin.query.access-controller", null);
    }

    public int getQueryMaxCacheStatementNum() {
        return Integer.parseInt(this.getOptional("kylin.query.statement-cache-max-num", String.valueOf(50000)));
    }

    public int getQueryMaxCacheStatementInstancePerKey() {
        return Integer.parseInt(this.getOptional("kylin.query.statement-cache-max-num-per-key", String.valueOf(50)));
    }

    public boolean isQueryPreparedStatementCacheEnable() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.statement-cache-enabled", TRUE));
    }

    public int getDimCountDistinctMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.query.max-dimension-count-distinct", "5000000"));
    }

    public Map<String, String> getUDFs() {
        LinkedHashMap<String, String> udfMap = Maps.newLinkedHashMap();
        udfMap.put("version", "org.apache.kylin.query.udf.VersionUDF");
        udfMap.put("concat", "org.apache.kylin.query.udf.ConcatUDF");
        udfMap.put("massin", "org.apache.kylin.query.udf.MassInUDF");
        Map<String, String> overrideUdfMap = this.getPropertiesByPrefix("kylin.query.udf.");
        udfMap.putAll(overrideUdfMap);
        return udfMap;
    }

    public int getQueryTimeoutSeconds() {
        int time = Integer.parseInt(this.getOptional("kylin.query.timeout-seconds", "0"));
        if (time != 0 && time <= 60) {
            logger.warn("query timeout seconds less than 60 sec, set to 60 sec.");
            time = 60;
        }
        return time;
    }

    public boolean isPushDownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.enabled", FALSE)) || StringUtils.isNotEmpty(this.getPushDownRunnerClassName());
    }

    public boolean isPushDownUpdateEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.update-enabled", FALSE));
    }

    public String getSchemaFactory() {
        return this.getOptional("kylin.query.schema-factory", "org.apache.kylin.query.schema.OLAPSchemaFactory");
    }

    public String getPushDownRunnerClassName() {
        return this.getOptional("kylin.query.pushdown.runner-class-name", "");
    }

    public List<String> getPushDownRunnerIds() {
        ArrayList<String> ids = Lists.newArrayList();
        String idsStr = this.getOptional("kylin.query.pushdown.runner.ids", "");
        if (StringUtils.isNotEmpty(idsStr)) {
            for (String id : idsStr.split(",")) {
                ids.add(id);
            }
        }
        return ids;
    }

    public String[] getPushDownConverterClassNames() {
        return this.getOptionalStringArray("kylin.query.pushdown.converter-class-names", new String[]{"org.apache.kylin.source.adhocquery.HivePushDownConverter"});
    }

    public boolean isPushdownQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.cache-enabled", FALSE));
    }

    public String getJdbcUrl(String id) {
        if (null == id) {
            return this.getOptional("kylin.query.pushdown.jdbc.url", "");
        }
        return this.getOptional("kylin.query.pushdown." + id + ".jdbc.url", "");
    }

    public String getJdbcDriverClass(String id) {
        if (null == id) {
            return this.getOptional("kylin.query.pushdown.jdbc.driver", "");
        }
        return this.getOptional("kylin.query.pushdown." + id + ".jdbc.driver", "");
    }

    public String getJdbcUsername(String id) {
        if (null == id) {
            return this.getOptional("kylin.query.pushdown.jdbc.username", "");
        }
        return this.getOptional("kylin.query.pushdown." + id + ".jdbc.username", "");
    }

    public String getJdbcPassword(String id) {
        if (null == id) {
            return this.getOptional("kylin.query.pushdown.jdbc.password", "");
        }
        return this.getOptional("kylin.query.pushdown." + id + ".jdbc.password", "");
    }

    public int getPoolMaxTotal(String id) {
        if (null == id) {
            return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-total", "8"));
        }
        return Integer.parseInt(this.getOptional("kylin.query.pushdown." + id + ".jdbc.pool-max-total", "8"));
    }

    public int getPoolMaxIdle(String id) {
        if (null == id) {
            return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-max-idle", "8"));
        }
        return Integer.parseInt(this.getOptional("kylin.query.pushdown." + id + ".jdbc.pool-max-idle", "8"));
    }

    public int getPoolMinIdle(String id) {
        if (null == id) {
            return Integer.parseInt(this.getOptional("kylin.query.pushdown.jdbc.pool-min-idle", "0"));
        }
        return Integer.parseInt(this.getOptional("kylin.query.pushdown." + id + ".jdbc.pool-min-idle", "0"));
    }

    public boolean isTableACLEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security.table-acl-enabled", TRUE));
    }

    public boolean isEscapeDefaultKeywordEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.escape-default-keyword", FALSE));
    }

    public String getQueryRealizationFilter() {
        return this.getOptional("kylin.query.realization-filter", null);
    }

    public String getSQLResponseSignatureClass() {
        return this.getOptional("kylin.query.signature-class", "org.apache.kylin.rest.signature.FactTableRealizationSetCalculator");
    }

    public boolean isQueryCacheSignatureEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache-signature-enabled", String.valueOf(this.isMemcachedEnabled())));
    }

    public int getFlatFilterMaxChildrenSize() {
        return Integer.parseInt(this.getOptional("kylin.query.flat-filter-max-children", "500000"));
    }

    public String getServerMode() {
        return this.getOptional("kylin.server.mode", "all");
    }

    public String[] getRestServers() {
        return this.getOptionalStringArray("kylin.server.cluster-servers", new String[0]);
    }

    public String getServerRestAddress() {
        return this.getOptional("kylin.server.host-address", "localhost:7070");
    }

    public boolean getServerSelfDiscoveryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.self-discovery-enabled", FALSE));
    }

    public String getClusterName() {
        String key = "kylin.server.cluster-name";
        String clusterName = this.getOptional(key, this.getMetadataUrlPrefix());
        this.setProperty(key, clusterName);
        return clusterName;
    }

    public String getInitTasks() {
        return this.getOptional("kylin.server.init-tasks");
    }

    public int getWorkersPerServer() {
        return Integer.parseInt(this.getOptional("kylin.server.sequence-sql.workers-per-server", "1"));
    }

    public long getSequenceExpireTime() {
        return Long.parseLong(this.getOptional("kylin.server.sequence-sql.expire-time", "86400000"));
    }

    public boolean getQueryMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics-enabled", FALSE));
    }

    public boolean getQueryMetrics2Enabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.server.query-metrics2-enabled", FALSE));
    }

    public int[] getQueryMetricsPercentilesIntervals() {
        String[] dft = new String[]{"60", "300", "3600"};
        return this.getOptionalIntArray("kylin.server.query-metrics-percentiles-intervals", dft);
    }

    public int getServerUserCacheExpireSeconds() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.expire-seconds", "300"));
    }

    public int getServerUserCacheMaxEntries() {
        return Integer.parseInt(this.getOptional("kylin.server.auth-user-cache.max-entries", "100"));
    }

    public String getSecurityProfile() {
        return this.getOptional("kylin.security.profile", "testing");
    }

    public String getExternalAclProvider() {
        return this.getOptional("kylin.server.external-acl-provider", "");
    }

    public String getLDAPUserSearchBase() {
        return this.getOptional("kylin.security.ldap.user-search-base", "");
    }

    public String getLDAPGroupSearchBase() {
        return this.getOptional("kylin.security.ldap.user-group-search-base", "");
    }

    public String getLDAPAdminRole() {
        return this.getOptional("kylin.security.acl.admin-role", "");
    }

    public boolean createAdminWhenAbsent() {
        return Boolean.parseBoolean(this.getOptional("kylin.security.create-admin-when-absent", FALSE));
    }

    public String getTimeZone() {
        String timezone = this.getOptional("kylin.web.timezone");
        if (StringUtils.isBlank(timezone)) {
            timezone = TimeZone.getDefault().getID();
        }
        return timezone;
    }

    public boolean isWebCrossDomainEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.cross-domain-enabled", TRUE));
    }

    public boolean isAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-admin", TRUE));
    }

    public boolean isNoneAdminUserExportAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.export-allow-other", TRUE));
    }

    public boolean isWebDashboardEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.dashboard-enabled", FALSE));
    }

    public boolean isWebConfigEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.web.set-config-enable", FALSE));
    }

    public String getPropertiesWhiteListForModification() {
        return this.getOptional("kylin.web.properties.whitelist", "kylin.query.cache-enabled");
    }

    public String getPropertiesWhiteList() {
        return this.getOptional("kylin.web.properties.whitelist", "kylin.web.timezone,kylin.query.cache-enabled,kylin.env,kylin.web.hive-limit,kylin.storage.default,kylin.engine.default,kylin.web.link-hadoop,kylin.web.link-diagnostic,kylin.web.contact-mail,kylin.web.help.length,kylin.web.help.0,kylin.web.help.1,kylin.web.help.2,kylin.web.help.3,kylin.web.help,kylin.web.hide-measures,kylin.web.link-streaming-guide,kylin.server.external-acl-provider,kylin.security.profile,kylin.security.additional-profiles,kylin.htrace.show-gui-trace-toggle,kylin.web.export-allow-admin,kylin.web.export-allow-other,kylin.cube.cubeplanner.enabled,kylin.web.dashboard-enabled,kylin.tool.auto-migrate-cube.enabled,kylin.job.scheduler.default,kylin.web.default-time-filter");
    }

    public int getRestClientDefaultMaxPerRoute() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.default-max-per-route", "20"));
    }

    public int getRestClientMaxTotal() {
        return Integer.parseInt(this.getOptional("kylin.restclient.connection.max-total", "200"));
    }

    public String getCoadhaleMetricsReportClassesNames() {
        return this.getOptional("kylin.metrics.reporter-classes", "org.apache.kylin.common.metrics.metrics2.JsonFileMetricsReporter,org.apache.kylin.common.metrics.metrics2.JmxMetricsReporter");
    }

    public String getMetricsFileLocation() {
        return this.getOptional("kylin.metrics.file-location", "/tmp/report.json");
    }

    public Long getMetricsReporterFrequency() {
        return Long.parseLong(this.getOptional("kylin.metrics.file-frequency", "5000"));
    }

    public String getPerfLoggerClassName() {
        return this.getOptional("kylin.metrics.perflogger-class", "org.apache.kylin.common.metrics.perflog.PerfLogger");
    }

    public boolean isShowingGuiTraceToggle() {
        return Boolean.parseBoolean(this.getOptional("kylin.htrace.show-gui-trace-toggle", FALSE));
    }

    public boolean isHtraceTracingEveryQuery() {
        return Boolean.parseBoolean(this.getOptional("kylin.htrace.trace-every-query", FALSE));
    }

    public String getKylinMetricsEventTimeZone() {
        return this.getOptional("kylin.metrics.event-time-zone", this.getTimeZone()).toUpperCase(Locale.ROOT);
    }

    public boolean isKylinMetricsMonitorEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.monitor-enabled", FALSE));
    }

    public boolean isKylinMetricsReporterForQueryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.reporter-query-enabled", FALSE));
    }

    public boolean isKylinMetricsReporterForJobEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.metrics.reporter-job-enabled", FALSE));
    }

    public String getKylinMetricsPrefix() {
        return this.getOptional("kylin.metrics.prefix", "KYLIN").toUpperCase(Locale.ROOT);
    }

    public String getKylinMetricsActiveReservoirDefaultClass() {
        return this.getOptional("kylin.metrics.active-reservoir-default-class", "org.apache.kylin.metrics.lib.impl.StubReservoir");
    }

    public String getKylinSystemCubeSinkDefaultClass() {
        return this.getOptional("kylin.metrics.system-cube-sink-default-class", "org.apache.kylin.metrics.lib.impl.hive.HiveSink");
    }

    public String getKylinMetricsSubjectSuffix() {
        return this.getOptional("kylin.metrics.subject-suffix", this.getDeployEnv());
    }

    public String getKylinMetricsSubjectJob() {
        return this.getOptional("kylin.metrics.subject-job", "METRICS_JOB") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectJobException() {
        return this.getOptional("kylin.metrics.subject-job-exception", "METRICS_JOB_EXCEPTION") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQueryExecution() {
        return this.getOptional("kylin.metrics.subject-query-execution", "METRICS_QUERY_EXECUTION") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQuerySparkJob() {
        return this.getOptional("kylin.metrics.subject-query-spark-job", "METRICS_QUERY_SPARK_JOB") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public String getKylinMetricsSubjectQuerySparkStage() {
        return this.getOptional("kylin.metrics.subject-query-spark-stage", "METRICS_QUERY_SPARK_STAGE") + "_" + this.getKylinMetricsSubjectSuffix();
    }

    public int getKylinMetricsCacheExpireSeconds() {
        return Integer.parseInt(this.getOptional("kylin.metrics.query-cache.expire-seconds", "300"));
    }

    public int getKylinMetricsCacheMaxEntries() {
        return Integer.parseInt(this.getOptional("kylin.metrics.query-cache.max-entries", "10000"));
    }

    public Map<String, String> getKylinMetricsConf() {
        return this.getPropertiesByPrefix("kylin.metrics.");
    }

    public int printSampleEventRatio() {
        String val = this.getOptional("kylin.metrics.kafka-sample-ratio", "10000");
        return Integer.parseInt(val);
    }

    public boolean isAllowAutoMigrateCube() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.enabled", FALSE));
    }

    public boolean isAutoMigrateCubeCopyAcl() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.copy-acl", TRUE));
    }

    public boolean isAutoMigrateCubePurge() {
        return Boolean.parseBoolean(this.getOptional("kylin.tool.auto-migrate-cube.purge-src-cube", TRUE));
    }

    public String getAutoMigrateCubeSrcConfig() {
        return this.getOptional("kylin.tool.auto-migrate-cube.src-config", "");
    }

    public String getAutoMigrateCubeDestConfig() {
        return this.getOptional("kylin.tool.auto-migrate-cube.dest-config", "");
    }

    public String getMetadataDialect() {
        return this.getOptional("kylin.metadata.jdbc.dialect", "mysql");
    }

    public boolean isJsonAlwaysSmallCell() {
        return Boolean.parseBoolean(this.getOptional("kylin.metadata.jdbc.json-always-small-cell", TRUE));
    }

    public int getSmallCellMetadataWarningThreshold() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.small-cell-meta-size-warning-threshold", String.valueOf(0x6400000)));
    }

    public int getSmallCellMetadataErrorThreshold() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.small-cell-meta-size-error-threshold", String.valueOf(0x40000000)));
    }

    public int getJdbcResourceStoreMaxCellSize() {
        return Integer.parseInt(this.getOptional("kylin.metadata.jdbc.max-cell-size", "1048576"));
    }

    public boolean isLimitPushDownEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.storage.limit-push-down-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getLocalStorageImpl() {
        return this.getOptional("kylin.stream.settled.storage", null);
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getStreamingDerivedTimeTimezone() {
        return this.getOptional("kylin.stream.event.timezone", "");
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public String getHiveDatabaseLambdaCube() {
        return this.getOptional("kylin.stream.hive.database-for-lambda-cube", DEFAULT);
    }

    public int getWarningSegmentNum() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.warning-segment-num", "-1"));
    }

    public int getWarningCubeExpansionRate() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.warning-cube-expansion-rate", "5"));
    }

    public int getExpansionCheckMinCubeSizeInGb() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.expansion-check.min-cube-size-gb", "500"));
    }

    public int getStaleCubeThresholdInDays() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.stale-cube-threshold-days", "100"));
    }

    public int getStaleJobThresholdInDays() {
        return Integer.parseInt(this.getOptional("kylin.tool.health-check.stale-job-threshold-days", "30"));
    }

    public String getKylinParquetJobJarPath() {
        String jobJar = this.getOptional(KYLIN_ENGINE_PARQUET_JOB_JAR);
        if (StringUtils.isNotEmpty(jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty(kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", PARQUET_JOB_JAR_NAME_PATTERN);
    }

    public void overrideKylinParquetJobJarPath(String path) {
        logger.info("override {} to {}", (Object)KYLIN_ENGINE_PARQUET_JOB_JAR, (Object)path);
        System.setProperty(KYLIN_ENGINE_PARQUET_JOB_JAR, path);
    }

    @ConfigTag(value={ConfigTag.Tag.DEBUG_HACK})
    public String getSparkBuildClassName() {
        return this.getOptional("kylin.engine.spark.build-class-name", "org.apache.kylin.engine.spark.job.CubeBuildJob");
    }

    @ConfigTag(value={ConfigTag.Tag.DEBUG_HACK})
    public String getSparkSampleTableClassName() {
        return this.getOptional("kylin.engine.spark.sample-class-name", "org.apache.kylin.engine.spark.job.TableAnalyzerJob");
    }

    public int getSparkSampleTableMaxRows() {
        String maxRows = this.getOptional("kylin.engine.spark.sample-max-rows", "1000");
        return Integer.parseInt(maxRows);
    }

    public Boolean getSparkEngineTaskImpactInstanceEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.spark.task-impact-instance-enabled", TRUE));
    }

    public int getSparkEngineTaskCoreFactor() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.task-core-factor", "3"));
    }

    public int getSparkEngineDriverMemoryBase() {
        return Integer.parseInt(this.getOptional("kylin.engine.driver-memory-base", "1024"));
    }

    public boolean isTrackingUrlIpAddressEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.job.tracking-url-ip-address-enabled", TRUE));
    }

    public int[] getSparkEngineDriverMemoryStrategy() {
        String[] dft = new String[]{"2", "20", "100"};
        return this.getOptionalIntArray("kylin.engine.driver-memory-strategy", dft);
    }

    public int getSparkEngineDriverMemoryMaximum() {
        return Integer.parseInt(this.getOptional("kylin.engine.driver-memory-maximum", "4096"));
    }

    public StorageURL getJobTmpMetaStoreUrl(String project, String jobId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("path", this.getJobTmpDir(project) + this.getNestedPath(jobId) + "meta");
        return new StorageURL(this.getMetadataUrlPrefix(), "hdfs", params);
    }

    public Path getJobTmpShareDir(String project, String jobId) {
        String path = this.getJobTmpDir(project) + jobId + "/share/";
        return new Path(path);
    }

    private String getNestedPath(String id) {
        String[] ids = id.split("_");
        StringBuilder builder = new StringBuilder();
        for (String subId : ids) {
            builder.append(subId).append("/");
        }
        return builder.toString();
    }

    public String getJobTmpDir(String project) {
        return this.getHdfsWorkingDirectory() + project + "/job_tmp/";
    }

    public String getSparkLogDir(String project) {
        return this.getHdfsWorkingDirectory() + project + "/spark_logs/driver/";
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getPersistFlatTableThreshold() {
        return Integer.parseInt(this.getOptional("kylin.engine.persist-flattable-threshold", "1"));
    }

    public Path getJobTmpFlatTableDir(String project, String jobId) {
        String path = this.getJobTmpDir(project) + jobId + "/flat_table/";
        return new Path(path);
    }

    public boolean isSnapshotParallelBuildEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.snapshot.parallel-build-enabled", TRUE));
    }

    public boolean isUTEnv() {
        return "UT".equals(this.getDeployEnv());
    }

    public boolean isLocalEnv() {
        return "LOCAL".equals(this.getDeployEnv());
    }

    public int snapshotParallelBuildTimeoutSeconds() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.parallel-build-timeout-seconds", "3600"));
    }

    public String getStorageProvider() {
        return this.getOptional("kylin.storage.provider", "org.apache.kylin.common.storage.DefaultStorageProvider");
    }

    public int getParquetStorageShardSizeMB() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.shard-size-mb", "128"));
    }

    public long getParquetStorageShardSizeRowCount() {
        return Long.valueOf(this.getOptional("kylin.storage.columnar.shard-rowcount", "2500000"));
    }

    public long getParquetStorageCountDistinctShardSizeRowCount() {
        return Long.valueOf(this.getOptional("kylin.storage.columnar.shard-countdistinct-rowcount", "1000000"));
    }

    public int getParquetStorageRepartitionThresholdSize() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.repartition-threshold-size-mb", "128"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getParquetStorageShardMin() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.shard-min", "1"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getParquetStorageShardMax() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.shard-max", "1000"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getParquetStorageBlockSize() {
        int defaultBlockSize = 5 * this.getParquetStorageShardSizeMB() * 1024 * 1024;
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.hdfs-blocksize-bytes", String.valueOf(defaultBlockSize < 0 ? Integer.MAX_VALUE : defaultBlockSize)));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getParquetSpliceShardExpandFactor() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.shard-expand-factor", "10"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public int getParquetDfsReplication() {
        return Integer.valueOf(this.getOptional("kylin.storage.columnar.dfs-replication", "3"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public String getBuildConf() {
        return this.getOptional("kylin.engine.submit-hadoop-conf-dir", "");
    }

    public boolean isJobLogPrintEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.log-print-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.DEBUG_HACK})
    public String getClusterInfoFetcherClassName() {
        return this.getOptional("kylin.engine.spark.cluster-info-fetcher-class-name", "org.apache.kylin.cluster.YarnInfoFetcher");
    }

    @ConfigTag(value={ConfigTag.Tag.DEBUG_HACK})
    public String getSparkMergeClassName() {
        return this.getOptional("kylin.engine.spark.merge-class-name", "org.apache.kylin.engine.spark.job.CubeMergeJob");
    }

    public int getSparkEngineMaxRetryTime() {
        return Integer.parseInt(this.getOptional("kylin.engine.max-retry-time", "3"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getSnapshotShardSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.shard-size-mb", "128"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public boolean isSegmentStatisticsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.engine.segment-statistics-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public String getParentDatasetStorageLevel() {
        return this.getOptional("kylin.engine.spark.cache-parent-dataset-storage-level", "NONE");
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getMaxParentDatasetPersistCount() {
        return Integer.parseInt(this.getOptional("kylin.engine.spark.cache-parent-dataset-count", "1"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean isBuildBaseCuboid() {
        return Boolean.valueOf(this.getOptional("kylin.engine.build-base-cuboid-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean isIgnoringNullInCheckDupKeyEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.job.ignoring-null-in-check-dup-key-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean isAutoSetSparkConf() {
        return Boolean.parseBoolean(this.getOptional("kylin.spark-conf.auto.prior", TRUE));
    }

    public double getSparkEngineRetryMemoryGradient() {
        return Double.parseDouble(this.getOptional("kylin.engine.retry-memory-gradient", "1.5"));
    }

    public double getSparkEngineRetryOverheadMemoryGradient() {
        return Double.parseDouble(this.getOptional("kylin.engine.retry-overheadMemory-gradient", "0.2"));
    }

    public Double getMaxAllocationResourceProportion() {
        return Double.parseDouble(this.getOptional("kylin.engine.max-allocation-proportion", "0.9"));
    }

    public int getSparkEngineBaseExecutorInstances() {
        return Integer.parseInt(this.getOptional("kylin.engine.base-executor-instance", "5"));
    }

    public String getSparkEngineRequiredTotalCores() {
        return this.getOptional("kylin.engine.spark.required-cores", "1");
    }

    public String getSparkEngineExecutorInstanceStrategy() {
        return this.getOptional("kylin.engine.executor-instance-strategy", "100,2,500,3,1000,4");
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getGlobalDictV2MinHashPartitions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-min-hash-partitions", "10"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getGlobalDictV2ThresholdBucketSize() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-threshold-bucket-size", "500000"));
    }

    public int getDictionarySliceEvicationThreshold() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.slice.eviction.threshold", "5"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public double getGlobalDictV2InitLoadFactor() {
        return Double.parseDouble(this.getOptional("kylin.dictionary.globalV2-init-load-factor", "0.5"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public double getGlobalDictV2BucketOverheadFactor() {
        return Double.parseDouble(this.getOptional("kylin.dictionary.globalV2-bucket-overhead-factor", "1.5"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getGlobalDictV2MaxVersions() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.globalV2-max-versions", "3"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public long getGlobalDictV2VersionTTL() {
        return Long.parseLong(this.getOptional("kylin.dictionary.globalV2-version-ttl", "259200000"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean isCheckGlobalDictV2() {
        return Boolean.parseBoolean(this.getOptional("kylin.dictionary.globalV2-check-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean detectDataSkewInDictEncodingEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.dictionary.detect-data-skew-sample-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public double sampleRateInEncodingSkewDetection() {
        return Double.valueOf(this.getOptional("kylin.dictionary.detect-data-skew-sample-rate", "0.1"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public double skewPercentageThreshHold() {
        return Double.valueOf(this.getOptional("kylin.dictionary.detect-data-skew-percentage-threshold", "0.05"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean rePartitionEncodedDatasetWithRowKey() {
        return Boolean.valueOf(this.getOptional("kylin.engine.spark.repartition.dataset.after.encode-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getRepartitionNumAfterEncode() {
        return Integer.valueOf(this.getOptional("kylin.engine.spark.repartition.dataset.after.encode.num", "0"));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public String getSparkStandaloneMasterWebUI() {
        return this.getOptional("kylin.engine.spark.standalone.master.httpUrl", "");
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public String getSparderAppName() {
        String customSparderAppName = this.getOptional("kylin.query.sparder-context.app-name", "");
        if (StringUtils.isEmpty(customSparderAppName)) {
            customSparderAppName = "sparder_on_" + this.getServerRestAddress().replaceAll(":", "-");
        }
        return customSparderAppName;
    }

    @ConfigTag(value={ConfigTag.Tag.DEPRECATED})
    public double getJoinMemoryFraction() {
        return Double.parseDouble(this.getOptional("kylin.query.spark-engine.join-memory-fraction", "0.3"));
    }

    @ConfigTag(value={ConfigTag.Tag.DEBUG_HACK})
    public boolean isSparkEngineEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.spark-engine.enabled", TRUE));
    }

    public String getLogSparkDriverPropertiesFile() {
        return this.getLogPropertyFile(this.getLogSparkDriverProperties());
    }

    public boolean isDefaultLogSparkDriverProperties() {
        return "spark-driver-log4j-default.properties".equals(this.getLogSparkDriverProperties());
    }

    public String getLogSparkDriverProperties() {
        return this.getOptional("kylin.spark.driver.log4j.properties", "spark-driver-log4j-default.properties");
    }

    public String getLogSparkExecutorPropertiesFile() {
        return this.getLogPropertyFile(this.getLogSparkExecutorProperties());
    }

    public boolean isDefaultLogSparkExecutorProperties() {
        return "spark-executor-log4j-default.properties".equals(this.getLogSparkExecutorProperties());
    }

    public String getLogSparkExecutorProperties() {
        return this.getOptional("kylin.spark.executor.log4j.properties", "spark-executor-log4j-default.properties");
    }

    private String getLogPropertyFile(String filename) {
        if (this.isDevEnv()) {
            return Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "build", "conf") + File.separator + filename;
        }
        return Paths.get(KylinConfigBase.getKylinHomeWithoutWarn(), "conf") + File.separator + filename;
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getSparkSqlShufflePartitions() {
        return Integer.parseInt(this.getOptional("kylin.query.spark-engine.spark-sql-shuffle-partitions", "-1"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getQueryPartitionSplitSizeMB() {
        return Integer.parseInt(this.getOptional("kylin.query.spark-engine.partition-split-size-mb", "64"));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public boolean isAutoSetPushDownPartitions() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.pushdown.auto-set-shuffle-partitions-enabled", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public int getBaseShufflePartitionSize() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.base-shuffle-partition-size", "48"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public int getMaxShardingSizeMBPerTask() {
        return Integer.parseInt(this.getOptional("kylin.query.spark-engine.max-sharding-size-mb", "64"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean isShardingJoinOptEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.spark-engine.expose-sharding-trait", TRUE));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public Map<String, String> getQuerySparkConf() {
        return this.getPropertiesByPrefix("kylin.query.spark-conf.");
    }

    public String getIntersectFilterOrSeparator() {
        return this.getOptional("kylin.query.intersect.separator", "|");
    }

    public int getDefaultTimeFilter() {
        return Integer.parseInt(this.getOptional("kylin.web.default-time-filter", "2"));
    }

    public int getBitmapValuesUpperBound() {
        return Integer.parseInt(this.getOptional("kylin.query.bitmap-upper-bound", "10000000"));
    }

    @ConfigTag(value={ConfigTag.Tag.CUBE_LEVEL})
    public boolean needReplaceAggWhenExactlyMatched() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.need-replace-exactly-agg", TRUE));
    }

    public String sparkUploadFiles(boolean isLocal, boolean isYarnCluster) {
        try {
            String path = "";
            if (!isLocal) {
                String executorLogPath = "";
                String driverLogPath = "";
                File executorLogFile = FileUtils.findFile(KylinConfigBase.getKylinHome() + "/conf", this.getLogSparkExecutorProperties());
                if (executorLogFile != null) {
                    executorLogPath = executorLogFile.getCanonicalPath();
                }
                path = executorLogPath;
                if (isYarnCluster) {
                    File driverLogFile = FileUtils.findFile(KylinConfigBase.getKylinHome() + "/conf", this.getLogSparkDriverProperties());
                    if (driverLogFile != null) {
                        driverLogPath = driverLogFile.getCanonicalPath();
                    }
                    path = executorLogPath + "," + driverLogPath;
                }
            }
            return this.getOptional("kylin.query.engine.sparder-additional-files", path);
        }
        catch (IOException e) {
            return "";
        }
    }

    public String sparkUploadFiles() {
        return this.sparkUploadFiles(false, false);
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String sparderJars() {
        try {
            File storageFile = FileUtils.findFile(KylinConfigBase.getKylinHome() + "/lib", "newten-job.jar");
            String path1 = "";
            if (storageFile != null) {
                path1 = storageFile.getCanonicalPath();
            }
            return this.getOptional("kylin.query.engine.sparder-additional-jars", path1);
        }
        catch (IOException e) {
            return "";
        }
    }

    public String getJobOutputStorePath(String project, String jobId) {
        return this.getSparkLogDir(project) + this.getNestedPath(jobId) + "execute_output.json";
    }

    @ConfigTag(value={ConfigTag.Tag.PROJECT_LEVEL, ConfigTag.Tag.THREAD_LEVEL})
    public String getProjectQuerySparkPool() {
        return this.getOptional("kylin.query.spark.pool", null);
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public boolean isAutoStartSparder() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.auto-sparder-context-enabled", FALSE));
    }

    public Integer sparkQueryMetrics() {
        return Integer.parseInt(this.getOptional("kylin.query.spark.metrics", "2"));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public boolean isSparderCanaryEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.canary.sparder-context-canary-enabled", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public int getSparderCanaryErrorResponseMs() {
        return Integer.parseInt(this.getOptional("kylin.canary.sparder-context-error-response-ms", "3000"));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public int getThresholdToRestartSparder() {
        return Integer.parseInt(this.getOptional("kylin.canary.sparder-context-threshold-to-restart-spark", "3"));
    }

    @ConfigTag(value={ConfigTag.Tag.GLOBAL_LEVEL})
    public int getSparderCanaryPeriodMinutes() {
        return Integer.parseInt(this.getOptional("kylin.canary.sparder-context-period-min", "3"));
    }

    public Boolean isKerberosEnabled() {
        return Boolean.valueOf(this.getOptional("kylin.kerberos.enabled", FALSE));
    }

    public String getKerberosKeytab() {
        return this.getOptional("kylin.kerberos.keytab", "");
    }

    public String getKerberosKeytabPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosKeytab();
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosZKPrincipal() {
        return this.getOptional("kylin.kerberos.zookeeper.server.principal", "zookeeper/hadoop");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public Long getKerberosTicketRefreshInterval() {
        return Long.valueOf(this.getOptional("kylin.kerberos.ticket.refresh.interval.minutes", "720"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public Long getKerberosMonitorInterval() {
        return Long.valueOf(this.getOptional("kylin.kerberos.monitor.interval.minutes", "10"));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosPlatform() {
        return this.getOptional("kylin.kerberos.platform", "");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public Boolean getPlatformZKEnable() {
        return Boolean.valueOf(this.getOptional("kylin.platform.zk.kerberos.enable", FALSE));
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosKrb5Conf() {
        return this.getOptional("kylin.kerberos.krb5.conf", "krb5.conf");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosKrb5ConfPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosKrb5Conf();
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosJaasConf() {
        return this.getOptional("kylin.kerberos.jaas.conf", "jaas.conf");
    }

    @ConfigTag(value={ConfigTag.Tag.NOT_CLEAR})
    public String getKerberosJaasConfPath() {
        return KylinConfig.getKylinConfDir() + File.separator + this.getKerberosJaasConf();
    }

    public String getKerberosPrincipal() {
        return this.getOptional("kylin.kerberos.principal");
    }

    public String getEncryptCipherIvSpec() {
        return this.getOptional("kylin.security.encrypt.cipher.ivSpec", "AAAAAAAAAAAAAAAA");
    }

    public boolean isEnabledNoAggQuery() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.enable-no-aggregate-query", FALSE));
    }
}

