/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public abstract class SpanningTree
implements Serializable {
    protected final Collection<LayoutEntity> cuboids;

    public SpanningTree(Collection<LayoutEntity> cuboids) {
        this.cuboids = cuboids;
    }

    public abstract boolean isValid(long var1);

    public abstract int getCuboidCount();

    public abstract Collection<LayoutEntity> getRootIndexEntities();

    public abstract LayoutEntity getLayoutEntity(long var1);

    public abstract void decideTheNextLayer(Collection<LayoutEntity> var1, SegmentInfo var2);

    public abstract Collection<LayoutEntity> getChildrenByIndexPlan(LayoutEntity var1);

    public abstract Collection<LayoutEntity> getAllIndexEntities();

    public static class TreeNode
    implements Serializable {
        @JsonProperty(value="cuboid")
        protected final LayoutEntity indexEntity;
        @JsonProperty(value="children")
        protected final ArrayList<TreeNode> children = Lists.newArrayList();
        @JsonProperty(value="level")
        protected int level;
        protected transient TreeNode parent;
        protected transient List<LayoutEntity> parentCandidates;
        protected transient boolean hasBeenDecided = false;

        public TreeNode(LayoutEntity indexEntity) {
            this.indexEntity = indexEntity;
        }

        public String toString() {
            return "level:" + this.level + ", node:" + this.indexEntity.getId() + ", dim:" + this.indexEntity.getOrderedDimensions().keySet().toString() + ", measure:" + this.indexEntity.getOrderedMeasures().keySet().toString() + ", children:{" + this.children.toString() + "}";
        }
    }
}

