/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.Arrays;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.VectorUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=3, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=1, jvmArgsAppend={"-Xmx1g", "-Xms1g", "-XX:+AlwaysPreTouch", "--add-modules", "jdk.incubator.vector"})
public class CompetitiveBenchmark {
    private final SplittableRandom R = new SplittableRandom(0L);
    @Param(value={"128"})
    int size;
    double[] scores;
    int[] docs;
    @Param(value={"0", "0.2", "0.4", "0.5", "0.8"})
    double minScoreInclusive;

    @Setup(value=Level.Trial)
    public void setUpTrial() {
        this.scores = new double[this.size];
        this.docs = new int[this.size];
    }

    @Setup(value=Level.Invocation)
    public void setUpInvocation() {
        for (int i = 0; i < this.size; ++i) {
            this.docs[i] = this.R.nextInt(Integer.MAX_VALUE);
            this.scores[i] = this.R.nextDouble();
        }
    }

    @Benchmark
    public int baseline() {
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            if (!(this.scores[i] >= this.minScoreInclusive)) continue;
            this.docs[newSize] = this.docs[i];
            this.scores[newSize] = this.scores[i];
            ++newSize;
        }
        return newSize;
    }

    @Benchmark
    public int branchlessCandidate() {
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            int inc = this.scores[i] >= this.minScoreInclusive ? 1 : 0;
            this.docs[newSize] = this.docs[i];
            this.scores[newSize] = this.scores[i];
            newSize += inc;
        }
        return newSize;
    }

    @Benchmark
    public int branchlessCandidateCmov() {
        int newSize = 0;
        for (int i = 0; i < this.size; ++i) {
            int doc = this.docs[i];
            double score = this.scores[i];
            this.docs[newSize] = doc;
            this.scores[newSize] = score;
            if (!(score >= this.minScoreInclusive)) continue;
            ++newSize;
        }
        return newSize;
    }

    @Benchmark
    public int vectorizedCandidate() {
        return VectorUtil.filterByScore((int[])this.docs, (double[])this.scores, (double)this.minScoreInclusive, (int)this.size);
    }

    public static void main(String[] args) {
        CompetitiveBenchmark baseline = new CompetitiveBenchmark();
        baseline.size = 128;
        baseline.setUpTrial();
        baseline.setUpInvocation();
        int baselineSize = baseline.baseline();
        CompetitiveBenchmark candidate = new CompetitiveBenchmark();
        candidate.size = 128;
        candidate.setUpTrial();
        candidate.setUpInvocation();
        IntSupplier[] intSupplierArray = new IntSupplier[3];
        intSupplierArray[0] = candidate::branchlessCandidate;
        intSupplierArray[1] = candidate::vectorizedCandidate;
        intSupplierArray[2] = candidate::branchlessCandidateCmov;
        for (IntSupplier s : intSupplierArray) {
            int candidateSize = s.getAsInt();
            if (baselineSize != candidateSize) {
                throw new IllegalArgumentException("incorrect size");
            }
            if (!Arrays.equals(baseline.docs, 0, baselineSize, candidate.docs, 0, candidateSize)) {
                throw new IllegalArgumentException("incorrect docs,\nbaseline: " + Arrays.toString(ArrayUtil.copyOfSubArray((int[])baseline.docs, (int)0, (int)baselineSize)) + "\ncandidate: " + Arrays.toString(ArrayUtil.copyOfSubArray((int[])candidate.docs, (int)0, (int)candidateSize)));
            }
            if (Arrays.equals(baseline.scores, 0, baselineSize, candidate.scores, 0, candidateSize)) continue;
            throw new IllegalArgumentException("incorrect scores");
        }
    }
}

