/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

public class BitMap {
    int defaultCapacity;
    int capacity;
    int[] map;
    int limitPos;
    final boolean extendCapacity;

    public BitMap(int n, boolean bl) {
        int n2 = n / 32;
        if (n % 32 != 0) {
            ++n2;
        }
        this.defaultCapacity = this.capacity = n2 * 32;
        this.map = new int[n2];
        this.limitPos = 0;
        this.extendCapacity = bl;
    }

    public BitMap(int[] nArray) {
        this.map = nArray;
        this.defaultCapacity = this.capacity = nArray.length * 32;
        this.limitPos = this.capacity;
        this.extendCapacity = false;
    }

    public int size() {
        return this.limitPos;
    }

    public void setSize(int n) {
        while (n > this.capacity) {
            this.doubleCapacity();
        }
        this.limitPos = n;
    }

    public void reset() {
        if (this.capacity == this.defaultCapacity) {
            for (int i = 0; i < this.map.length; ++i) {
                this.map[i] = 0;
            }
        } else {
            this.map = new int[this.defaultCapacity / 32];
            this.capacity = this.defaultCapacity;
        }
        this.limitPos = 0;
    }

    public void setRange(int n, int n2) {
        this.setOrUnsetRange(n, n2, true);
    }

    public void unsetRange(int n, int n2) {
        this.setOrUnsetRange(n, n2, false);
    }

    private void setOrUnsetRange(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (n + n2 > this.capacity) {
            this.doubleCapacity();
        }
        if (n + n2 > this.limitPos) {
            this.limitPos = n + n2;
        }
        if ((n4 = n >> 5) == (n3 = n + n2 - 1 >> 5)) {
            int n5 = -1 >>> (n & 0x1F);
            int n6 = Integer.MIN_VALUE >> (n + n2 - 1 & 0x1F);
            n5 &= n6;
            int n7 = this.map[n4];
            this.map[n4] = bl ? n7 | n5 : n7 & (n5 ^= 0xFFFFFFFF);
            return;
        }
        int n8 = -1 >>> (n & 0x1F);
        int n9 = this.map[n4];
        this.map[n4] = bl ? n9 | n8 : n9 & (n8 ^= 0xFFFFFFFF);
        n8 = Integer.MIN_VALUE >> (n + n2 - 1 & 0x1F);
        n9 = this.map[n3];
        this.map[n3] = bl ? n9 | n8 : n9 & (n8 ^= 0xFFFFFFFF);
        for (int i = n4 + 1; i < n3; ++i) {
            this.map[i] = bl ? -1 : 0;
        }
    }

    public int setValue(int n, boolean bl) {
        return bl ? this.set(n) : this.unset(n);
    }

    public int set(int n) {
        int n2;
        int n3;
        int n4;
        while (n >= this.capacity) {
            this.doubleCapacity();
        }
        if (n >= this.limitPos) {
            this.limitPos = n + 1;
        }
        int n5 = ((n4 = this.map[n3 = n >> 5]) & (n2 = Integer.MIN_VALUE >>> (n & 0x1F))) == 0 ? 0 : 1;
        this.map[n3] = n4 | n2;
        return n5;
    }

    public int unset(int n) {
        while (n >= this.capacity) {
            this.doubleCapacity();
        }
        if (n >= this.limitPos) {
            this.limitPos = n + 1;
            return 0;
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        int n5 = (n3 & n4) == 0 ? 0 : 1;
        this.map[n2] = n3 & (n4 ^= 0xFFFFFFFF);
        return n5;
    }

    public int get(int n) {
        if (n >= this.limitPos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = n >> 5;
        int n3 = this.map[n2];
        int n4 = Integer.MIN_VALUE >>> (n & 0x1F);
        return (n3 & n4) == 0 ? 0 : 1;
    }

    public boolean isSet(int n) {
        return this.get(n) == 1;
    }

    public int countSet(int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            if (!this.isSet(i)) continue;
            ++n3;
        }
        return n3;
    }

    public int countSetBits() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.limitPos / 32; ++n) {
            int n3 = this.map[n];
            if (n3 == 0) continue;
            if (n3 == -1) {
                n2 += 32;
                continue;
            }
            n2 += Integer.bitCount(n3);
        }
        if (this.limitPos % 32 != 0) {
            n = this.map[this.limitPos / 32];
            n2 += Integer.bitCount(n);
        }
        return n2;
    }

    public int countSetBitsEnd() {
        int n = 0;
        for (int i = this.limitPos / 32 - 1; i >= 0; --i) {
            if (this.map[i] == -1) {
                n += 32;
                continue;
            }
            int n2 = BitMap.countSetBitsLow(this.map[i]);
            n += n2;
            break;
        }
        return n;
    }

    public int[] getIntArray() {
        return this.map;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[(this.limitPos + 7) / 8];
        if (byArray.length == 0) {
            return byArray;
        }
        int n = 0;
        do {
            int n2 = this.map[n / 4];
            byArray[n++] = (byte)(n2 >>> 24);
            if (n == byArray.length) break;
            byArray[n++] = (byte)(n2 >>> 16);
            if (n == byArray.length) break;
            byArray[n++] = (byte)(n2 >>> 8);
            if (n == byArray.length) break;
            byArray[n++] = (byte)n2;
        } while (n != byArray.length);
        return byArray;
    }

    private void doubleCapacity() {
        if (!this.extendCapacity) {
            throw new ArrayStoreException("BitMap extend");
        }
        int[] nArray = new int[this.map.length * 2];
        this.capacity *= 2;
        System.arraycopy(this.map, 0, nArray, 0, this.map.length);
        this.map = nArray;
    }

    public static int countSetBitsLow(int n) {
        int n2;
        int n3 = 1;
        for (n2 = 0; n2 < 32 && (n & n3) != 0; ++n2) {
            n >>= 1;
        }
        return n2;
    }

    public static int setByte(int n, byte by, int n2) {
        int n3 = (by & 0xFF) << 24 - n2;
        int n4 = -16777216 >>> n2;
        return (n &= (n4 ^= 0xFFFFFFFF)) | n3;
    }

    public static int set(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n | n3;
    }

    public static byte set(byte by, int n) {
        int n2 = 128 >>> n;
        return (byte)(by | n2);
    }

    public static int unset(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return n & (n3 ^= 0xFFFFFFFF);
    }

    public static boolean isSet(int n, int n2) {
        int n3 = Integer.MIN_VALUE >>> n2;
        return (n & n3) != 0;
    }

    public static boolean isSet(byte by, int n) {
        int n2 = 128 >>> n;
        return (by & n2) != 0;
    }

    public static boolean isSet(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return false;
        }
        byte by = byArray[n3];
        return (by & n2) != 0;
    }

    public static void unset(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        n2 ^= 0xFFFFFFFF;
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return;
        }
        byte by = byArray[n3];
        byArray[n3] = (byte)(by & n2);
    }

    public static void set(byte[] byArray, int n) {
        int n2 = 128 >>> (n & 7);
        int n3 = n / 8;
        if (n3 >= byArray.length) {
            return;
        }
        byte by = byArray[n3];
        byArray[n3] = (byte)(by | n2);
    }

    public static void and(byte[] byArray, int n, byte by, int n2) {
        int n3 = n & 7;
        int n4 = (by & 0xFF) >>> n3;
        int n5 = 255 >> n3;
        int n6 = n / 8;
        if (n2 < 8) {
            n5 >>>= 8 - n2;
            n5 <<= 8 - n2;
        }
        n4 &= n5;
        n5 ^= 0xFFFFFFFF;
        if (n6 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n6];
        byArray[n6] = (byte)(by2 & n5);
        by2 = (byte)(by2 & n4);
        byArray[n6] = (byte)(byArray[n6] | by2);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by & 0xFF) << 8 >>> n3;
            n5 = 65280 >>> n3;
            by2 = byArray[n6 + 1];
            byArray[n6 + 1] = (byte)(by2 & (n5 ^= 0xFFFFFFFF));
            by2 = (byte)(by2 & n4);
            byArray[n6 + 1] = (byte)(byArray[n6 + 1] | by2);
        }
    }

    public static void or(byte[] byArray, int n, byte by, int n2) {
        byte by2;
        int n3 = n & 7;
        int n4 = (by & 0xFF) >>> n3;
        int n5 = n / 8;
        if (n5 >= byArray.length) {
            return;
        }
        byArray[n5] = by2 = (byte)(byArray[n5] | n4);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by & 0xFF) << 8 >>> n3;
            byArray[n5 + 1] = by2 = (byte)(byArray[n5 + 1] | n4);
        }
    }

    public static void overlay(byte[] byArray, int n, byte by, int n2) {
        int n3 = n & 7;
        int n4 = (by & 0xFF) >>> n3;
        int n5 = 255 >> n3;
        int n6 = n / 8;
        if (n2 < 8) {
            n5 >>>= 8 - n2;
            n5 <<= 8 - n2;
        }
        n4 &= n5;
        n5 ^= 0xFFFFFFFF;
        if (n6 >= byArray.length) {
            return;
        }
        byte by2 = byArray[n6];
        by2 = (byte)(by2 & n5);
        byArray[n6] = (byte)(by2 | n4);
        if (n3 == 0) {
            return;
        }
        if (n2 > (n3 = 8 - n3)) {
            n4 = (by & 0xFF) << 8 >>> n3;
            n5 = 65280 >>> n3;
            by2 = byArray[n6 + 1];
            by2 = (byte)(by2 & (n5 ^= 0xFFFFFFFF));
            byArray[n6 + 1] = (byte)(by2 | n4);
        }
    }

    public static byte[] and(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] & byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] or(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        if (n != n2) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n2, byArray3, n2, n - n2);
        }
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] | byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length > byArray2.length ? byArray.length : byArray2.length;
        int n2 = byArray.length > byArray2.length ? byArray2.length : byArray.length;
        byte[] byArray3 = new byte[n];
        if (n != n2) {
            byte[] byArray4 = byArray.length > byArray2.length ? byArray : byArray2;
            System.arraycopy(byArray4, n2, byArray3, n2, n - n2);
        }
        for (int i = 0; i < n2; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    public static byte[] not(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = ~byArray[i];
        }
        return byArray2;
    }

    public static boolean hasAnyBitSet(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == 0) continue;
            return true;
        }
        return false;
    }

    public static byte[] leftShift(byte[] byArray, int n) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = n / 8;
        if (n2 >= byArray.length) {
            return byArray2;
        }
        if ((n %= 8) == 0) {
            int n3 = 0;
            for (int i = n2; i < byArray.length; ++i) {
                byArray2[n3] = byArray[i];
                ++n3;
            }
        } else {
            int n4 = 0;
            for (int i = n2; i < byArray.length; ++i) {
                int n5 = (byArray[i] & 0xFF) << n;
                byArray2[n4] = (byte)n5;
                if (n4 > 0) {
                    int n6 = n4 - 1;
                    byArray2[n6] = (byte)(byArray2[n6] | (byte)(n5 >>> 8));
                }
                ++n4;
            }
        }
        return byArray2;
    }
}

