/*
 * Decompiled with CFR 0.152.
 */
package org.castor.persist.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.persist.ProposedEntity;
import org.castor.persist.TransactionContext;
import org.castor.persist.UpdateAndRemovedFlags;
import org.castor.persist.UpdateFlags;
import org.castor.persist.resolver.ResolverStrategy;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.ClassMolder;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.spi.Identity;

public final class SerializableResolver
implements ResolverStrategy {
    private static final Log LOG = LogFactory.getLog((Class)SerializableResolver.class);
    private FieldMolder _fieldMolder;
    private int _fieldIndex;

    public SerializableResolver(ClassMolder classMolder, FieldMolder fieldMolder, int fieldIndex, boolean debug) {
        this._fieldMolder = fieldMolder;
        this._fieldIndex = fieldIndex;
    }

    public Object create(TransactionContext tx, Object object) throws PersistenceException {
        byte[] field = null;
        try {
            Object dependent = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (dependent != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(dependent);
                field = bos.toByteArray();
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Error during serializing dependent object", e);
        }
        return field;
    }

    public boolean markCreate(TransactionContext tx, OID oid, Object object) {
        boolean updateCache = false;
        return updateCache;
    }

    public UpdateFlags preStore(TransactionContext tx, OID oid, Object object, int timeout, Object field) throws PersistenceException {
        UpdateFlags flags = new UpdateFlags();
        try {
            byte[] bytes = (byte[])field;
            Object fieldValue = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (fieldValue != null && bytes != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream os = new ObjectInputStream(bis);
                Object dependent = os.readObject();
                if (!dependent.equals(fieldValue)) {
                    if (this._fieldMolder.isStored() && this._fieldMolder.isCheckDirty()) {
                        flags.setUpdatePersist(true);
                    }
                    flags.setUpdateCache(true);
                }
            } else if (fieldValue != null || bytes != null) {
                if (this._fieldMolder.isStored()) {
                    flags.setUpdatePersist(true);
                }
                flags.setUpdateCache(true);
            }
        }
        catch (OptionalDataException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (IOException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        return flags;
    }

    public Object store(TransactionContext tx, Object object, Object field) throws PersistenceException {
        byte[] newField = null;
        try {
            Object dependent = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (dependent != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(dependent);
                newField = bos.toByteArray();
            }
        }
        catch (IOException e) {
            throw new PersistenceException("Error during serializing dependent object", e);
        }
        return newField;
    }

    public void update(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode, Object field) {
    }

    public Object updateCache(TransactionContext tx, OID oid, Object object) {
        byte[] field = null;
        try {
            Object o = this._fieldMolder.getValue(object, tx.getClassLoader());
            if (o != null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(o);
                field = bos.toByteArray();
            }
        }
        catch (IOException e) {
            String msg = "ByteArrayOutputStream throw IOException: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
        }
        return field;
    }

    public void markDelete(TransactionContext tx, Object object, Object field) {
    }

    public void revertObject(TransactionContext tx, OID oid, Object object, Object field) throws PersistenceException {
        try {
            byte[] bytes = (byte[])field;
            if (bytes != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream os = new ObjectInputStream(bis);
                Object o = os.readObject();
                this._fieldMolder.setValue(object, o, tx.getClassLoader());
            } else {
                this._fieldMolder.setValue(object, null, tx.getClassLoader());
            }
        }
        catch (OptionalDataException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (IOException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
    }

    public void expireCache(TransactionContext tx, Object field) {
    }

    public void load(TransactionContext tx, OID oid, ProposedEntity proposedObject, AccessMode suggestedAccessMode) throws PersistenceException {
        try {
            byte[] bytes = (byte[])proposedObject.getField(this._fieldIndex);
            if (bytes != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream os = new ObjectInputStream(bis);
                Object object = os.readObject();
                this._fieldMolder.setValue(proposedObject.getEntity(), object, tx.getClassLoader());
            } else {
                this._fieldMolder.setValue(proposedObject.getEntity(), null, tx.getClassLoader());
            }
        }
        catch (OptionalDataException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
        catch (IOException e) {
            throw new PersistenceException("Error while deserializing an dependent object", e);
        }
    }

    public Object postCreate(TransactionContext tx, OID oid, Object object, Object field, Identity createdId) {
        return field;
    }

    public UpdateAndRemovedFlags removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        return new UpdateAndRemovedFlags();
    }

    public boolean updateWhenNoTimestampSet(TransactionContext tx, OID oid, Object object, AccessMode suggestedAccessMode) throws PersistenceException {
        return false;
    }
}

