/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.distribution.EnumeratedIntegerDistribution;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class EnumeratedDistributionEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    private static final long serialVersionUID = 1L;

    public EnumeratedDistributionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (values.length == 0) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - null found for the first value", this.toExpression(this.constructingFactory)));
        }
        if (values.length == 1) {
            List first = (List)values[0];
            int[] samples = first.stream().mapToInt(value -> ((Number)value).intValue()).toArray();
            return new EnumeratedIntegerDistribution(samples);
        }
        List first = (List)values[0];
        List second = (List)values[1];
        int[] singletons = first.stream().mapToInt(value -> ((Number)value).intValue()).toArray();
        double[] probs = second.stream().mapToDouble(value -> ((Number)value).doubleValue()).toArray();
        return new EnumeratedIntegerDistribution(singletons, probs);
    }
}

