/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;

public interface DataEntry {
    public Type type();

    public long index();

    public int intVal();

    public long longVal();

    public float floatVal();

    public double doubleVal();

    public boolean boolVal();

    default public String strValue() {
        if (this.type() == null) {
            return null;
        }
        return this.val().toString();
    }

    public Object val();

    public void listenContainer(Object var1, EntryListener var2);

    public Object metadata();

    public int depth();

    public DataEntry parent();

    public Object ctx();

    public int length();

    public boolean isKeyValEntry();

    public CharSequence name();

    public static interface FastDecoder {
        public FastDecoder withInputStream(InputStream var1);

        public Object decode(EntryListener var1) throws IOException;
    }

    public static interface EntryListener {
        public void entry(DataEntry var1);

        default public void end(DataEntry e) {
        }
    }

    public static enum Type {
        NULL(true),
        LONG(true),
        INT(true),
        BOOL(true),
        FLOAT(true),
        DOUBLE(true),
        DATE(true),
        KEYVAL_ITER(false, true),
        ENTRY_ITER(false, true),
        STR(false),
        BYTEARR(false),
        JAVA_OBJ(false);

        public final boolean isPrimitive;
        public final boolean isContainer;

        private Type(boolean isPrimitive) {
            this(isPrimitive, false);
        }

        private Type(boolean isPrimitive, boolean isContainer) {
            this.isPrimitive = isPrimitive;
            this.isContainer = isContainer;
        }
    }
}

