/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.client.objects.task;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.client.NuxeoClient;
import org.nuxeo.client.methods.TaskManagerAPI;
import org.nuxeo.client.objects.AbstractConnectable;
import org.nuxeo.client.objects.task.Task;
import org.nuxeo.client.objects.task.TaskCompletionRequest;
import org.nuxeo.client.objects.task.Tasks;

public class TaskManager
extends AbstractConnectable<TaskManagerAPI, TaskManager> {
    public TaskManager(NuxeoClient nuxeoClient) {
        super(TaskManagerAPI.class, nuxeoClient);
    }

    public Tasks fetchTasks(String userId, String workflowInstanceId, String workflowModelName) {
        return this.fetchResponse(((TaskManagerAPI)this.api).fetchTasks(userId, workflowInstanceId, workflowModelName));
    }

    public Task fetchTask(String taskId) {
        return this.fetchResponse(((TaskManagerAPI)this.api).fetchTask(taskId));
    }

    public Task reassign(String taskId, List<String> actors, String comment) {
        String actorsValue = StringUtils.join(actors, (String)",");
        return this.reassign(taskId, actorsValue, comment);
    }

    public Task reassign(String taskId, String actors, String comment) {
        return this.fetchResponse(((TaskManagerAPI)this.api).reassign(taskId, actors, comment));
    }

    public Task delegate(String taskId, List<String> actors, String comment) {
        String actorsValue = StringUtils.join(actors, (String)",");
        return this.delegate(taskId, actorsValue, comment);
    }

    public Task delegate(String taskId, String actors, String comment) {
        return this.fetchResponse(((TaskManagerAPI)this.api).delegate(taskId, actors, comment));
    }

    public Task complete(String taskId, String action, TaskCompletionRequest taskCompletionRequest) {
        taskCompletionRequest.taskId = taskId;
        return this.fetchResponse(((TaskManagerAPI)this.api).complete(taskId, action, taskCompletionRequest));
    }
}

