/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Objects;
import org.apache.sis.feature.AbstractAssociation;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.DefaultAssociationRole;

final class SingletonAssociation
extends AbstractAssociation {
    private static final long serialVersionUID = -5247767277033831214L;
    private AbstractFeature value;

    public SingletonAssociation(DefaultAssociationRole defaultAssociationRole) {
        super(defaultAssociationRole);
        assert (SingletonAssociation.isSingleton(defaultAssociationRole.getMaximumOccurs()));
    }

    SingletonAssociation(DefaultAssociationRole defaultAssociationRole, AbstractFeature abstractFeature) {
        super(defaultAssociationRole);
        assert (SingletonAssociation.isSingleton(defaultAssociationRole.getMaximumOccurs()));
        this.value = abstractFeature;
        if (abstractFeature != null) {
            this.ensureValid(defaultAssociationRole.getValueType(), abstractFeature.getType());
        }
    }

    @Override
    public AbstractFeature getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractFeature abstractFeature) throws IllegalArgumentException {
        if (abstractFeature != null) {
            this.ensureValid(this.role.getValueType(), abstractFeature.getType());
        }
        this.value = abstractFeature;
    }

    public int hashCode() {
        return this.role.hashCode() + Objects.hashCode(this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SingletonAssociation) {
            SingletonAssociation singletonAssociation = (SingletonAssociation)object;
            return this.role.equals(singletonAssociation.role) && Objects.equals(this.value, singletonAssociation.value);
        }
        return false;
    }
}

