/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.intent.Intent;
import org.netbeans.api.io.HyperlinkAccessorImpl;
import org.netbeans.modules.io.HyperlinkAccessor;
import org.openide.util.Parameters;

public abstract class Hyperlink {
    private final boolean important;

    private Hyperlink(boolean important) {
        this.important = important;
    }

    boolean isImportant() {
        return this.important;
    }

    @NonNull
    public static Hyperlink from(@NonNull Runnable runnable) {
        return Hyperlink.from(runnable, false);
    }

    @NonNull
    public static Hyperlink from(@NonNull Runnable runnable, boolean important) {
        Parameters.notNull("runnable", runnable);
        return new OnClickHyperlink(runnable, important);
    }

    public static Hyperlink from(@NonNull Intent intent) {
        return Hyperlink.from(intent, false);
    }

    public static Hyperlink from(@NonNull Intent intent, boolean important) {
        Parameters.notNull("intent", intent);
        return new IntentHyperlink(intent, important);
    }

    static {
        HyperlinkAccessor.setDefault(new HyperlinkAccessorImpl());
    }

    static class OnClickHyperlink
    extends Hyperlink {
        private final Runnable runnable;

        public OnClickHyperlink(Runnable runnable, boolean important) {
            super(important);
            this.runnable = runnable;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }
    }

    static class IntentHyperlink
    extends Hyperlink {
        private final Intent intent;

        public IntentHyperlink(Intent intent, boolean important) {
            super(important);
            this.intent = intent;
        }

        public Intent getIntent() {
            return this.intent;
        }
    }
}

