/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.time;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationFormat {
    private static final String UNION = "|";
    private static final String NANOS = String.join((CharSequence)"|", "ns", "nano", "nanos", "nanosecond", "nanoseconds");
    private static final String MILLIS = String.join((CharSequence)"|", "ms", "milli", "millis", "millisecond", "milliseconds");
    private static final String SECS = String.join((CharSequence)"|", "s", "sec", "secs", "second", "seconds");
    private static final String MINS = String.join((CharSequence)"|", "m", "min", "mins", "minute", "minutes");
    private static final String HOURS = String.join((CharSequence)"|", "h", "hr", "hrs", "hour", "hours");
    private static final String DAYS = String.join((CharSequence)"|", "d", "day", "days");
    private static final String WEEKS = String.join((CharSequence)"|", "w", "wk", "wks", "week", "weeks");
    private static final String VALID_TIME_UNITS = String.join((CharSequence)"|", NANOS, MILLIS, SECS, MINS, HOURS, DAYS, WEEKS);
    public static final String TIME_DURATION_REGEX = "([\\d.]+)\\s*(" + VALID_TIME_UNITS + ")";
    public static final Pattern TIME_DURATION_PATTERN = Pattern.compile(TIME_DURATION_REGEX);
    private static final List<Long> TIME_UNIT_MULTIPLIERS = Arrays.asList(1000L, 1000L, 1000L, 60L, 60L, 24L);

    private DurationFormat() {
    }

    public static long getTimeDuration(String value, TimeUnit desiredUnit) {
        return Math.round(DurationFormat.getPreciseTimeDuration(value, desiredUnit));
    }

    public static double getPreciseTimeDuration(String value, TimeUnit desiredUnit) {
        long durationLong;
        TimeUnit specifiedTimeUnit;
        Matcher matcher = TIME_DURATION_PATTERN.matcher(value.toLowerCase());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Value '" + value + "' is not a valid time duration");
        }
        String duration = matcher.group(1);
        String units = matcher.group(2);
        double durationVal = Double.parseDouble(duration);
        if (DurationFormat.isWeek(units)) {
            specifiedTimeUnit = TimeUnit.DAYS;
            durationVal *= 7.0;
        } else {
            specifiedTimeUnit = DurationFormat.determineTimeUnit(units);
        }
        if (durationVal == Math.rint(durationVal)) {
            durationLong = Math.round(durationVal);
        } else {
            List<Object> wholeResults = DurationFormat.makeWholeNumberTime(durationVal, specifiedTimeUnit);
            durationLong = (Long)wholeResults.get(0);
            specifiedTimeUnit = (TimeUnit)((Object)wholeResults.get(1));
        }
        return desiredUnit.convert(durationLong, specifiedTimeUnit);
    }

    static List<Object> makeWholeNumberTime(double decimal, TimeUnit timeUnit) {
        if (decimal == Math.rint(decimal)) {
            long rounded = Math.round(decimal);
            return Arrays.asList(new Object[]{rounded, timeUnit});
        }
        if (TimeUnit.NANOSECONDS == timeUnit) {
            decimal = decimal < 1.0 ? 1.0 : Math.rint(decimal);
            return Arrays.asList(new Object[]{(long)decimal, timeUnit});
        }
        TimeUnit smallerTimeUnit = DurationFormat.getSmallerTimeUnit(timeUnit);
        long multiplier = DurationFormat.calculateMultiplier(timeUnit, smallerTimeUnit);
        return DurationFormat.makeWholeNumberTime(decimal * (double)multiplier, smallerTimeUnit);
    }

    static long calculateMultiplier(TimeUnit originalTimeUnit, TimeUnit newTimeUnit) {
        if (originalTimeUnit == newTimeUnit) {
            return 1L;
        }
        if (originalTimeUnit.ordinal() < newTimeUnit.ordinal()) {
            throw new IllegalArgumentException("The original time unit '" + String.valueOf((Object)originalTimeUnit) + "' must be larger than the new time unit '" + String.valueOf((Object)newTimeUnit) + "'");
        }
        int originalOrd = originalTimeUnit.ordinal();
        int newOrd = newTimeUnit.ordinal();
        List<Long> unitMultipliers = TIME_UNIT_MULTIPLIERS.subList(newOrd, originalOrd);
        return unitMultipliers.stream().reduce(1L, (a, b) -> a * b);
    }

    static TimeUnit getSmallerTimeUnit(TimeUnit originalUnit) {
        if (originalUnit == null || TimeUnit.NANOSECONDS == originalUnit) {
            throw new IllegalArgumentException("Cannot determine a smaller time unit than '" + String.valueOf((Object)originalUnit) + "'");
        }
        return TimeUnit.values()[originalUnit.ordinal() - 1];
    }

    private static boolean isWeek(String rawUnit) {
        return switch (rawUnit) {
            case "w", "wk", "wks", "week", "weeks" -> true;
            default -> false;
        };
    }

    protected static TimeUnit determineTimeUnit(String rawUnit) {
        return switch (rawUnit.toLowerCase()) {
            case "ns", "nano", "nanos", "nanoseconds" -> TimeUnit.NANOSECONDS;
            case "\u00b5s", "micro", "micros", "microseconds" -> TimeUnit.MICROSECONDS;
            case "ms", "milli", "millis", "milliseconds" -> TimeUnit.MILLISECONDS;
            case "s", "sec", "secs", "second", "seconds" -> TimeUnit.SECONDS;
            case "m", "min", "mins", "minute", "minutes" -> TimeUnit.MINUTES;
            case "h", "hr", "hrs", "hour", "hours" -> TimeUnit.HOURS;
            case "d", "day", "days" -> TimeUnit.DAYS;
            default -> throw new IllegalArgumentException("Could not parse '" + rawUnit + "' to TimeUnit");
        };
    }
}

