/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class Uuid3Evaluator
extends StringEvaluator {
    private final Evaluator<String> subject;
    private final Evaluator<String> namespace;

    public Uuid3Evaluator(Evaluator<String> subject, Evaluator<String> namespace) {
        this.subject = subject;
        this.namespace = namespace;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        String subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        String nsValue = this.namespace.evaluate(evaluationContext).getValue();
        UUID nsUUID = nsValue == null ? new UUID(0L, 0L) : UUID.fromString(nsValue);
        byte[] nsBytes = ByteBuffer.wrap(new byte[16]).putLong(nsUUID.getMostSignificantBits()).putLong(nsUUID.getLeastSignificantBits()).array();
        byte[] subjectBytes = subjectValue.getBytes();
        byte[] nameBytes = ArrayUtils.addAll((byte[])nsBytes, (byte[])subjectBytes);
        return new StringQueryResult(UUID.nameUUIDFromBytes(nameBytes).toString());
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

